/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exchange.resource.organizations.masterOrganizationId.applications.applicationId;

import java.net.URLEncoder;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.mule.exchange.exceptions.ExchangexapiException;
import org.mule.exchange.resource.organizations.masterOrganizationId.applications.applicationId.contracts.Contracts;
import org.mule.exchange.resource.organizations.masterOrganizationId.applications.applicationId.environments.Environments;
import org.mule.exchange.resource.organizations.masterOrganizationId.applications.applicationId.instances.Instances;
import org.mule.exchange.resource.organizations.masterOrganizationId.applications.applicationId.model.ApplicationIdGETResponseBody;
import org.mule.exchange.resource.organizations.masterOrganizationId.applications.applicationId.model.ApplicationIdPATCHBody;
import org.mule.exchange.resource.organizations.masterOrganizationId.applications.applicationId.model.ApplicationIdPATCHResponseBody;
import org.mule.exchange.resource.organizations.masterOrganizationId.applications.applicationId.secret.Secret;
import org.mule.exchange.responses.ExchangexapiResponse;

public class ApplicationId {
    private String _baseUrl;
    private Client _client;
    public final Secret secret;
    public final Environments environments;
    public final Instances instances;
    public final Contracts contracts;

    public ApplicationId() {
        this._baseUrl = null;
        this._client = null;
        this.secret = null;
        this.environments = null;
        this.instances = null;
        this.contracts = null;
    }

    public ApplicationId(String baseUrl, Client _client, String uriParam) {
        this._baseUrl = baseUrl + "/" + URLEncoder.encode(uriParam);
        this._client = _client;
        this.secret = new Secret(this.getBaseUri(), this.getClient());
        this.environments = new Environments(this.getBaseUri(), this.getClient());
        this.instances = new Instances(this.getBaseUri(), this.getClient());
        this.contracts = new Contracts(this.getBaseUri(), this.getClient());
    }

    protected Client getClient() {
        return this._client;
    }

    private String getBaseUri() {
        return this._baseUrl;
    }

    public ExchangexapiResponse<ApplicationIdGETResponseBody> get(String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("GET");
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(response.readEntity(ApplicationIdGETResponseBody.class), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }

    public ExchangexapiResponse<ApplicationIdPATCHResponseBody> patch(ApplicationIdPATCHBody body, String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("PATCH", Entity.json((Object)body));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(response.readEntity(ApplicationIdPATCHResponseBody.class), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }

    public ExchangexapiResponse<Void> delete(String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("DELETE");
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(null, (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }
}

