/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exchange.resource.assets.groupId.assetId.version.reviews;

import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.mule.exchange.exceptions.ExchangexapiException;
import org.mule.exchange.resource.assets.groupId.assetId.version.reviews.model.ReviewsGETQueryParam;
import org.mule.exchange.resource.assets.groupId.assetId.version.reviews.model.ReviewsGETResponseBody;
import org.mule.exchange.resource.assets.groupId.assetId.version.reviews.model.ReviewsPOSTBody;
import org.mule.exchange.resource.assets.groupId.assetId.version.reviews.model.ReviewsPOSTResponseBody;
import org.mule.exchange.resource.assets.groupId.assetId.version.reviews.reviewId.ReviewId;
import org.mule.exchange.responses.ExchangexapiResponse;

public class Reviews {
    private String _baseUrl;
    private Client _client;

    public Reviews() {
        this._baseUrl = null;
        this._client = null;
    }

    public Reviews(String baseUrl, Client _client) {
        this._baseUrl = baseUrl + "/reviews";
        this._client = _client;
    }

    protected Client getClient() {
        return this._client;
    }

    private String getBaseUri() {
        return this._baseUrl;
    }

    public ExchangexapiResponse<List<ReviewsGETResponseBody>> get(ReviewsGETQueryParam queryParameters, String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        if (queryParameters.getIncludeComments() != null) {
            target = target.queryParam("includeComments", new Object[]{queryParameters.getIncludeComments()});
        }
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("GET");
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(response.readEntity((GenericType)new GenericType<List<ReviewsGETResponseBody>>(){}), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }

    public ExchangexapiResponse<ReviewsPOSTResponseBody> post(ReviewsPOSTBody body, String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("POST", Entity.json((Object)body));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(response.readEntity(ReviewsPOSTResponseBody.class), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }

    public ReviewId reviewId(String reviewId) {
        return new ReviewId(this.getBaseUri(), this.getClient(), reviewId);
    }
}

