/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exchange.resource.assets.groupId.assetId.version.portal;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.mule.exchange.exceptions.ExchangexapiException;
import org.mule.exchange.resource.assets.groupId.assetId.version.portal.draft.Draft;
import org.mule.exchange.resource.assets.groupId.assetId.version.portal.model.PortalGETResponseBody;
import org.mule.exchange.resource.assets.groupId.assetId.version.portal.pages.Pages;
import org.mule.exchange.resource.assets.groupId.assetId.version.portal.resources.Resources;
import org.mule.exchange.responses.ExchangexapiResponse;

public class Portal {
    private String _baseUrl;
    private Client _client;
    public final Draft draft;
    public final Pages pages;
    public final Resources resources;

    public Portal() {
        this._baseUrl = null;
        this._client = null;
        this.draft = null;
        this.pages = null;
        this.resources = null;
    }

    public Portal(String baseUrl, Client _client) {
        this._baseUrl = baseUrl + "/portal";
        this._client = _client;
        this.draft = new Draft(this.getBaseUri(), this.getClient());
        this.pages = new Pages(this.getBaseUri(), this.getClient());
        this.resources = new Resources(this.getBaseUri(), this.getClient());
    }

    protected Client getClient() {
        return this._client;
    }

    private String getBaseUri() {
        return this._baseUrl;
    }

    public ExchangexapiResponse<Void> patch(String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("PATCH", (Entity)null);
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(null, (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }

    public ExchangexapiResponse<PortalGETResponseBody> get(String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("GET");
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(response.readEntity(PortalGETResponseBody.class), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }
}

