/*
 * Decompiled with CFR 0.152.
 */
package com.antonionicolaspina.revealtextview;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.widget.TextView;
import com.antonionicolaspina.revealtextview.R;

public final class RevealTextView
extends TextView
implements Runnable,
ValueAnimator.AnimatorUpdateListener {
    private int animationDuration = 300;
    private String text;
    private int red;
    private int green;
    private int blue;
    private double[] alphas;

    public RevealTextView(Context context) {
        super(context);
        this.init(null);
    }

    public RevealTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context.getTheme().obtainStyledAttributes(attrs, R.styleable.RevealTextView, 0, 0));
    }

    public RevealTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context.getTheme().obtainStyledAttributes(attrs, R.styleable.RevealTextView, 0, 0));
    }

    @TargetApi(value=21)
    public RevealTextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context.getTheme().obtainStyledAttributes(attrs, R.styleable.RevealTextView, 0, 0));
    }

    protected void init(TypedArray attrs) {
        try {
            this.animationDuration = attrs.getInteger(R.styleable.RevealTextView_rtv_duration, this.animationDuration);
            this.text = attrs.getString(R.styleable.RevealTextView_android_text);
        }
        finally {
            attrs.recycle();
        }
        this.setAnimatedText(this.text);
    }

    @Override
    public void run() {
        int color = this.getCurrentTextColor();
        this.red = Color.red((int)color);
        this.green = Color.green((int)color);
        this.blue = Color.blue((int)color);
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 2.0f});
        animator.setDuration((long)this.animationDuration);
        animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        animator.start();
    }

    protected int clamp(double value) {
        return (int)(255.0 * Math.min(Math.max(value, 0.0), 1.0));
    }

    public void onAnimationUpdate(ValueAnimator valueAnimator) {
        float value = ((Float)valueAnimator.getAnimatedValue()).floatValue();
        SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)this.text);
        for (int i = 0; i < this.text.length(); ++i) {
            builder.setSpan((Object)new ForegroundColorSpan(Color.argb((int)this.clamp((double)value + this.alphas[i]), (int)this.red, (int)this.green, (int)this.blue)), i, i + 1, 33);
        }
        this.setText((CharSequence)builder);
    }

    public void replayAnimation() {
        if (null != this.text) {
            this.post(this);
        }
    }

    public void setAnimatedText(String text) {
        this.text = text;
        this.alphas = new double[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            this.alphas[i] = Math.random() - 1.0;
        }
        this.setText(text);
        this.replayAnimation();
    }
}

