/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.xsync;

import com.antkorwin.xsync.XMutex;
import com.antkorwin.xsync.XMutexFactory;
import com.antkorwin.xsync.XMutexFactoryImpl;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class XSync<KeyT> {
    private final XMutexFactory<KeyT> mutexFactory;
    private static final Object globalLock = new Object();

    public XSync() {
        this.mutexFactory = new XMutexFactoryImpl();
    }

    public XSync(XMutexFactory<KeyT> mutexFactory) {
        this.mutexFactory = mutexFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(KeyT mutexKey, Runnable runnable) {
        XMutex<KeyT> mutex;
        XMutex<KeyT> xMutex = mutex = this.mutexFactory.getMutex(mutexKey);
        synchronized (xMutex) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ResultT> ResultT evaluate(KeyT mutexKey, Supplier<ResultT> supplier) {
        XMutex<KeyT> mutex;
        XMutex<KeyT> xMutex = mutex = this.mutexFactory.getMutex(mutexKey);
        synchronized (xMutex) {
            return supplier.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(KeyT firstKey, KeyT secondKey, Runnable runnable) {
        Object object;
        int secondHash;
        XMutex<KeyT> firstMutex = this.mutexFactory.getMutex(firstKey);
        XMutex<KeyT> secondMutex = this.mutexFactory.getMutex(secondKey);
        int firstHash = System.identityHashCode(firstKey);
        if (firstHash > (secondHash = System.identityHashCode(secondKey))) {
            XMutex<KeyT> tmp = firstMutex;
            firstMutex = secondMutex;
            secondMutex = tmp;
        }
        if (firstHash != secondHash) {
            object = firstMutex;
            synchronized (object) {
                XMutex<KeyT> xMutex = secondMutex;
                synchronized (xMutex) {
                    runnable.run();
                }
            }
        }
        object = globalLock;
        synchronized (object) {
            XMutex<KeyT> xMutex = firstMutex;
            synchronized (xMutex) {
                XMutex<KeyT> xMutex2 = secondMutex;
                synchronized (xMutex2) {
                    runnable.run();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ResultT> ResultT evaluate(KeyT firstKey, KeyT secondKey, Supplier<ResultT> supplier) {
        Object object;
        int secondHash;
        XMutex<KeyT> firstMutex = this.mutexFactory.getMutex(firstKey);
        XMutex<KeyT> secondMutex = this.mutexFactory.getMutex(secondKey);
        int firstHash = System.identityHashCode(firstKey);
        if (firstHash > (secondHash = System.identityHashCode(secondKey))) {
            XMutex<KeyT> tmp = firstMutex;
            firstMutex = secondMutex;
            secondMutex = tmp;
        }
        if (firstHash != secondHash) {
            object = firstMutex;
            synchronized (object) {
                XMutex<KeyT> xMutex = secondMutex;
                synchronized (xMutex) {
                    return supplier.get();
                }
            }
        }
        object = globalLock;
        synchronized (object) {
            XMutex<KeyT> xMutex = firstMutex;
            synchronized (xMutex) {
                XMutex<KeyT> xMutex2 = secondMutex;
                synchronized (xMutex2) {
                    return supplier.get();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Collection<KeyT> keys, Runnable runnable) {
        if (keys.size() < 1) {
            throw new RuntimeException("Empty key list");
        }
        List<XMutex<KeyT>> mutexes = this.getOrderedMutexList(keys);
        if (this.existCollisionByHashCodes(mutexes)) {
            Object object = globalLock;
            synchronized (object) {
                this.recursiveExecute(mutexes, runnable);
            }
        } else {
            this.recursiveExecute(mutexes, runnable);
        }
    }

    private List<XMutex<KeyT>> getOrderedMutexList(Collection<KeyT> keys) {
        return keys.stream().map(this.mutexFactory::getMutex).sorted(Comparator.comparingInt(System::identityHashCode)).collect(Collectors.toList());
    }

    private boolean existCollisionByHashCodes(List<XMutex<KeyT>> mutexes) {
        List hashCodes = mutexes.stream().map(System::identityHashCode).collect(Collectors.toList());
        return hashCodes.size() < mutexes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursiveExecute(List<XMutex<KeyT>> mutexes, Runnable runnable) {
        XMutex<KeyT> currentMutex = mutexes.get(0);
        mutexes.remove(currentMutex);
        if (mutexes.size() == 0) {
            XMutex<KeyT> xMutex = currentMutex;
            synchronized (xMutex) {
                runnable.run();
            }
        }
        XMutex<KeyT> xMutex = currentMutex;
        synchronized (xMutex) {
            this.recursiveExecute(mutexes, runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ResultT> ResultT evaluate(Collection<KeyT> keys, Supplier<ResultT> supplier) {
        if (keys.size() < 1) {
            throw new RuntimeException("Empty key list");
        }
        List<XMutex<KeyT>> mutexes = this.getOrderedMutexList(keys);
        if (this.existCollisionByHashCodes(mutexes)) {
            Object object = globalLock;
            synchronized (object) {
                return this.recursiveEvaluate(mutexes, supplier);
            }
        }
        return this.recursiveEvaluate(mutexes, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ResultT> ResultT recursiveEvaluate(List<XMutex<KeyT>> mutexes, Supplier<ResultT> supplier) {
        XMutex<KeyT> currentMutex = mutexes.get(0);
        mutexes.remove(currentMutex);
        if (mutexes.size() == 0) {
            XMutex<KeyT> xMutex = currentMutex;
            synchronized (xMutex) {
                return supplier.get();
            }
        }
        XMutex<KeyT> xMutex = currentMutex;
        synchronized (xMutex) {
            return this.recursiveEvaluate(mutexes, supplier);
        }
    }
}

