/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.ioutils.temp;

import com.antkorwin.ioutils.temp.TempFileReference;
import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TempFileReaper {
    private volatile TempFileReaperThread reaperThread = null;
    private ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private Set<TempFileReference> references = Collections.newSetFromMap(new ConcurrentHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWhenUnused(File file) {
        this.references.add(new TempFileReference(file, this.referenceQueue));
        if (this.reaperThread == null) {
            TempFileReaper tempFileReaper = this;
            synchronized (tempFileReaper) {
                if (this.reaperThread == null) {
                    this.reaperThread = new TempFileReaperThread();
                    this.reaperThread.start();
                }
            }
        }
    }

    class TempFileReaperThread
    extends Thread {
        public TempFileReaperThread() {
            super("TempFileReaper");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (TempFileReaper.this.references.size() > 0) {
                try {
                    TempFileReference unusedReference = (TempFileReference)TempFileReaper.this.referenceQueue.remove();
                    TempFileReaper.this.references.remove(unusedReference);
                    unusedReference.delete();
                    unusedReference.clear();
                }
                catch (InterruptedException e) {}
            }
            TempFileReaper.this.reaperThread = null;
        }
    }
}

