/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.ioutils.resourcefile;

import com.antkorwin.ioutils.error.InternalException;
import com.antkorwin.throwable.functions.ThrowableSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;

public class ResourceFile {
    private final String fileName;

    public ResourceFile(String fileName) {
        this.fileName = fileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public String read() {
        try (InputStream inputStream = this.getResourceStream();){
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            throw new InternalException("Error while reading the data from file: " + this.fileName, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readAsString() {
        try (InputStream inputStream = this.getResourceStream();){
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            throw new InternalException("Error while reading the data from file: " + this.fileName, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readAsByteArray() {
        try (InputStream inputStream = this.getResourceStream();){
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
        catch (Exception e) {
            throw new InternalException("Error while reading the data from file: " + this.fileName, e);
        }
    }

    public void write(ThrowableSupplier<OutputStream> destinationStreamSupplier) {
        try (OutputStream outputStream = (OutputStream)destinationStreamSupplier.get();){
            IOUtils.write((byte[])this.readAsByteArray(), (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new InternalException("Error while writing data in the stream", e);
        }
    }

    public File getFile() {
        String filePath = this.startFilenameWithoutSlash();
        return new File(this.getClass().getClassLoader().getResource(filePath).getFile());
    }

    public InputStream getInputStream() {
        try {
            return this.getResourceStream();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    private InputStream getResourceStream() throws IOException {
        String filePath = this.startFilenameFromSlash();
        InputStream inputStream = this.getClass().getResourceAsStream(filePath);
        if (inputStream == null) {
            inputStream = this.getClass().getResourceAsStream(filePath);
        }
        if (inputStream == null) {
            inputStream = Files.newInputStream(Paths.get(this.fileName, new String[0]), new OpenOption[0]);
        }
        return inputStream;
    }

    private String startFilenameFromSlash() {
        return !this.fileName.startsWith("/") ? "/" + this.fileName : this.fileName;
    }

    private String startFilenameWithoutSlash() {
        return this.fileName.startsWith("/") ? this.fileName.replaceFirst("/", "") : this.fileName;
    }
}

