/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.ioutils.multipartfile;

import com.antkorwin.ioutils.error.InternalException;
import com.antkorwin.ioutils.multipartfile.ContentDispositionFactory;
import com.antkorwin.throwable.functions.ThrowableSupplier;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

public class FileResponse {
    private ThrowableSupplier<InputStream> fileInputStreamSupplier;
    private String filename;
    private String mimeType;
    private HttpServletResponse response;
    private String contentDisposition;
    private HttpStatus responseStatus;

    public static FileResponse builder() {
        return new FileResponse();
    }

    public HttpServletResponse build() {
        if (!StringUtils.isEmpty((Object)this.mimeType)) {
            this.response.setContentType(this.mimeType);
        }
        if (this.contentDisposition != null) {
            this.response.setHeader("Content-Disposition", this.contentDisposition);
        }
        if (!StringUtils.isEmpty((Object)this.filename)) {
            this.response.setHeader("Content-Disposition", ContentDispositionFactory.getWithUtf8Filename(this.filename));
        }
        try (InputStream inputStreamContent = (InputStream)this.fileInputStreamSupplier.get();){
            IOUtils.copy((InputStream)inputStreamContent, (OutputStream)this.response.getOutputStream());
            this.response.flushBuffer();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        this.response.setStatus(this.responseStatus == null ? 200 : this.responseStatus.value());
        return this.response;
    }

    public FileResponse file(ThrowableSupplier<InputStream> fileInputStream) {
        this.fileInputStreamSupplier = fileInputStream;
        return this;
    }

    public FileResponse file(File file) {
        this.fileInputStreamSupplier = () -> new FileInputStream(file);
        return this;
    }

    public FileResponse file(byte[] fileContent) {
        this.fileInputStreamSupplier = () -> new ByteArrayInputStream(fileContent);
        return this;
    }

    public FileResponse filename(String filename) {
        this.filename = filename;
        return this;
    }

    public FileResponse response(HttpServletResponse response) {
        this.response = response;
        return this;
    }

    public FileResponse mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public FileResponse contentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public FileResponse status(HttpStatus status) {
        this.responseStatus = status;
        return this;
    }
}

