/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.ioutils.multipartfile;

import com.antkorwin.ioutils.error.InternalException;
import com.antkorwin.ioutils.multipartfile.CustomDiskFileItem;
import com.antkorwin.throwable.functions.ThrowableSupplier;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.commons.fileupload.FileItem;
import org.springframework.core.io.Resource;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class CustomMultipartFile
implements MultipartFile {
    private final MultipartFile multipartFile;

    public CustomMultipartFile(String contentType, String dataFieldName, String originalFileName, String fileContentAsString, byte[] fileContentAsBytes, File fileContentFromFile, ThrowableSupplier<InputStream> fileContentAsInputStream) {
        if (fileContentAsInputStream == null) {
            fileContentAsInputStream = this.getInputStreamSupplier(fileContentFromFile, fileContentAsString, fileContentAsBytes);
        }
        String encodedFileName = this.encode(originalFileName);
        CustomDiskFileItem fileItem = new CustomDiskFileItem(encodedFileName, dataFieldName, contentType, fileContentAsInputStream);
        this.multipartFile = new CommonsMultipartFile((FileItem)fileItem);
    }

    private ThrowableSupplier<InputStream> getInputStreamSupplier(File fileContentFromFile, String fileContentAsString, byte[] fileContentAsBytes) {
        if (fileContentFromFile != null) {
            return () -> new FileInputStream(fileContentFromFile);
        }
        if (fileContentAsBytes != null) {
            return () -> new ByteArrayInputStream(fileContentAsBytes);
        }
        if (fileContentAsString != null) {
            return () -> new ByteArrayInputStream(fileContentAsString.getBytes());
        }
        throw new InternalException("Multipart file creating error.");
    }

    private String encode(String name) {
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            throw new InternalException("Filename encoding error.", exception);
        }
    }

    public static CustomMultipartFileBuilder builder() {
        return new CustomMultipartFileBuilder();
    }

    public String getName() {
        return this.multipartFile.getName();
    }

    public String getOriginalFilename() {
        return this.multipartFile.getOriginalFilename();
    }

    public String getContentType() {
        return this.multipartFile.getContentType();
    }

    public boolean isEmpty() {
        return this.multipartFile.isEmpty();
    }

    public long getSize() {
        return this.multipartFile.getSize();
    }

    public byte[] getBytes() throws IOException {
        return this.multipartFile.getBytes();
    }

    public InputStream getInputStream() throws IOException {
        return this.multipartFile.getInputStream();
    }

    public Resource getResource() {
        return this.multipartFile.getResource();
    }

    public void transferTo(File arg0) throws IOException, IllegalStateException {
        this.multipartFile.transferTo(arg0);
    }

    public void transferTo(Path dest) throws IOException, IllegalStateException {
        this.multipartFile.transferTo(dest);
    }

    public static class CustomMultipartFileBuilder {
        private String contentType;
        private String dataFieldName;
        private String originalFileName;
        private String fileContentAsString;
        private byte[] fileContentAsBytes;
        private File fileContentFromFile;
        private ThrowableSupplier<InputStream> fileContentAsInputStream;

        CustomMultipartFileBuilder() {
        }

        public CustomMultipartFileBuilder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public CustomMultipartFileBuilder dataFieldName(String dataFieldName) {
            this.dataFieldName = dataFieldName;
            return this;
        }

        public CustomMultipartFileBuilder originalFileName(String originalFileName) {
            this.originalFileName = originalFileName;
            return this;
        }

        public CustomMultipartFileBuilder fileContentAsString(String fileContentAsString) {
            this.fileContentAsString = fileContentAsString;
            return this;
        }

        public CustomMultipartFileBuilder fileContentAsBytes(byte[] fileContentAsBytes) {
            this.fileContentAsBytes = fileContentAsBytes;
            return this;
        }

        public CustomMultipartFileBuilder fileContentFromFile(File fileContentFromFile) {
            this.fileContentFromFile = fileContentFromFile;
            return this;
        }

        public CustomMultipartFileBuilder fileContentAsInputStream(ThrowableSupplier<InputStream> fileContentAsInputStream) {
            this.fileContentAsInputStream = fileContentAsInputStream;
            return this;
        }

        public CustomMultipartFile build() {
            return new CustomMultipartFile(this.contentType, this.dataFieldName, this.originalFileName, this.fileContentAsString, this.fileContentAsBytes, this.fileContentFromFile, this.fileContentAsInputStream);
        }

        public String toString() {
            return "CustomMultipartFile.CustomMultipartFileBuilder(contentType=" + this.contentType + ", dataFieldName=" + this.dataFieldName + ", originalFileName=" + this.originalFileName + ", fileContentAsString=" + this.fileContentAsString + ", fileContentAsBytes=" + Arrays.toString(this.fileContentAsBytes) + ", fileContentFromFile=" + this.fileContentFromFile + ", fileContentAsInputStream=" + this.fileContentAsInputStream + ")";
        }
    }
}

