/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.ioutils.multipartfile;

import com.antkorwin.throwable.functions.ThrowableSupplier;
import com.antkorwin.throwable.functions.WrappedException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.IOUtils;

public class CustomDiskFileItem
implements FileItem {
    private static final int IN_MEMORY_BUFFER_SIZE = 0x100000;
    private final FileItem fileItem;

    public CustomDiskFileItem(String originalFileName, String dataFieldName, String contentType, ThrowableSupplier<InputStream> inputStreamSupplier) {
        this.fileItem = new DiskFileItem(dataFieldName, contentType, true, originalFileName, 0x100000, null);
        this.prepareFileItemContent(this.fileItem, inputStreamSupplier);
    }

    private void prepareFileItemContent(FileItem fileItem, ThrowableSupplier<InputStream> inputStreamSupplier) {
        try (OutputStream fileItemOutputStream = fileItem.getOutputStream();
             BufferedInputStream fileInputStream = new BufferedInputStream((InputStream)inputStreamSupplier.get());){
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)fileItemOutputStream);
        }
        catch (IOException e) {
            throw new WrappedException((Throwable)e);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.fileItem.getInputStream();
    }

    public String getContentType() {
        return this.fileItem.getContentType();
    }

    public String getName() {
        return this.fileItem.getName();
    }

    public boolean isInMemory() {
        return this.fileItem.isInMemory();
    }

    public long getSize() {
        return this.fileItem.getSize();
    }

    public byte[] get() {
        return this.fileItem.get();
    }

    public String getString(String arg0) throws UnsupportedEncodingException {
        return this.fileItem.getString(arg0);
    }

    public String getString() {
        return this.fileItem.getString();
    }

    public void write(File arg0) throws Exception {
        this.fileItem.write(arg0);
    }

    public void delete() {
        this.fileItem.delete();
    }

    public String getFieldName() {
        return this.fileItem.getFieldName();
    }

    public void setFieldName(String arg0) {
        this.fileItem.setFieldName(arg0);
    }

    public boolean isFormField() {
        return this.fileItem.isFormField();
    }

    public void setFormField(boolean arg0) {
        this.fileItem.setFormField(arg0);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.fileItem.getOutputStream();
    }

    public FileItemHeaders getHeaders() {
        return this.fileItem.getHeaders();
    }

    public void setHeaders(FileItemHeaders arg0) {
        this.fileItem.setHeaders(arg0);
    }
}

