/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.ioutils.multipartfile;

import com.antkorwin.throwable.functions.ThrowableWrapper;
import java.net.URLEncoder;

public class ContentDispositionFactory {
    private static final String ALLOWED_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ._-~()[]{}0123456789";

    public static String getWithUtf8Filename(String filename) {
        return (String)ThrowableWrapper.get(() -> {
            String urlEncodedFileName = URLEncoder.encode(filename, "UTF-8").replaceAll("\\+", "%20");
            return "attachment;filename*=UTF-8''" + String.valueOf(urlEncodedFileName);
        });
    }

    public static String getWithAsciiFilename(String filename) {
        String escapedname = ContentDispositionFactory.makeSafeFileName(filename);
        return "attachment;filename=\"" + String.valueOf(escapedname) + "\"";
    }

    private static String makeSafeFileName(String fileName) {
        char[] newFileName = fileName.toCharArray();
        for (int i = 0; i < newFileName.length; ++i) {
            if (ALLOWED_CHARS.indexOf(newFileName[i]) != -1) continue;
            newFileName[i] = 95;
        }
        return new String(newFileName);
    }
}

