/*
 * Decompiled with CFR 0.152.
 */
package com.antkorwin.ioutils;

import com.antkorwin.ioutils.temp.TempFileReaper;
import com.antkorwin.throwable.functions.ThrowableSupplier;
import com.antkorwin.throwable.functions.ThrowableWrapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class TempFile {
    private static final TempFileReaper tempFileReaper = new TempFileReaper();

    public static File createFromInputStream(ThrowableSupplier<InputStream> inputStreamSupplier, String extension) {
        return (File)ThrowableWrapper.get(() -> {
            File tempFile = File.createTempFile("ioutils-", "." + extension);
            tempFile.deleteOnExit();
            tempFileReaper.deleteWhenUnused(tempFile);
            try (InputStream inputStream = (InputStream)inputStreamSupplier.get();
                 FileOutputStream out = new FileOutputStream(tempFile);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)out);
            }
            return tempFile;
        });
    }

    public static File createFromInputStream(ThrowableSupplier<InputStream> inputStreamSupplier) {
        return TempFile.createFromInputStream(inputStreamSupplier, "tmp");
    }

    public static File createFromString(String fileContent) {
        return TempFile.createFromInputStream((ThrowableSupplier<InputStream>)((ThrowableSupplier)() -> new ByteArrayInputStream(fileContent.getBytes())));
    }

    public static File createFromString(String fileContent, String extension) {
        return TempFile.createFromInputStream((ThrowableSupplier<InputStream>)((ThrowableSupplier)() -> new ByteArrayInputStream(fileContent.getBytes())), extension);
    }

    public static File createEmpty() {
        return (File)ThrowableWrapper.get(() -> {
            File tempFile = File.createTempFile("ioutils-", ".tmp");
            tempFile.deleteOnExit();
            tempFileReaper.deleteWhenUnused(tempFile);
            return tempFile;
        });
    }
}

