/*
 * Decompiled with CFR 0.152.
 */
package com.anthony.ultimateswipetool.view;

import android.view.View;
import com.anthony.ultimateswipetool.view.Attributes;
import com.anthony.ultimateswipetool.view.SwipeViewLayout;
import com.anthony.ultimateswipetool.view.interfaces.SwipeAdapterInterface;
import com.anthony.ultimateswipetool.view.interfaces.SwipeItemMangerInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SwipeItemMangerImpl
implements SwipeItemMangerInterface {
    private Attributes.Mode mode = Attributes.Mode.Single;
    public final int INVALID_POSITION = -1;
    protected int mOpenPosition = -1;
    protected Set<Integer> mOpenPositions = new HashSet<Integer>();
    protected Set<SwipeViewLayout> mShownLayouts = new HashSet<SwipeViewLayout>();
    protected SwipeAdapterInterface swipeAdapterInterface;

    public SwipeItemMangerImpl(SwipeAdapterInterface swipeAdapterInterface) {
        if (swipeAdapterInterface == null) {
            throw new IllegalArgumentException("SwipeAdapterInterface can not be null");
        }
        this.swipeAdapterInterface = swipeAdapterInterface;
    }

    @Override
    public Attributes.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(Attributes.Mode mode) {
        this.mode = mode;
        this.mOpenPositions.clear();
        this.mShownLayouts.clear();
        this.mOpenPosition = -1;
    }

    public void bind(View view, int position) {
        int resId = this.swipeAdapterInterface.getSwipeLayoutResourceId(position);
        SwipeViewLayout swipeLayout = (SwipeViewLayout)view.findViewById(resId);
        if (swipeLayout == null) {
            throw new IllegalStateException("can not find SwipeLayout in target view");
        }
        if (swipeLayout.getTag(resId) == null) {
            OnLayoutListener onLayoutListener = new OnLayoutListener(position);
            SwipeMemory swipeMemory = new SwipeMemory(position);
            swipeLayout.addSwipeListener(swipeMemory);
            swipeLayout.addOnLayoutListener(onLayoutListener);
            swipeLayout.setTag(resId, new ValueBox(position, swipeMemory, onLayoutListener));
            this.mShownLayouts.add(swipeLayout);
        } else {
            ValueBox valueBox = (ValueBox)swipeLayout.getTag(resId);
            valueBox.swipeMemory.setPosition(position);
            valueBox.onLayoutListener.setPosition(position);
            valueBox.position = position;
        }
    }

    @Override
    public void openItem(int position) {
        if (this.mode == Attributes.Mode.Multiple) {
            if (!this.mOpenPositions.contains(position)) {
                this.mOpenPositions.add(position);
            }
        } else {
            this.mOpenPosition = position;
        }
        this.swipeAdapterInterface.notifyDatasetChanged();
    }

    @Override
    public void closeItem(int position) {
        if (this.mode == Attributes.Mode.Multiple) {
            this.mOpenPositions.remove(position);
        } else if (this.mOpenPosition == position) {
            this.mOpenPosition = -1;
        }
        this.swipeAdapterInterface.notifyDatasetChanged();
    }

    @Override
    public void closeAllExcept(SwipeViewLayout layout) {
        for (SwipeViewLayout s : this.mShownLayouts) {
            if (s == layout) continue;
            s.close();
        }
    }

    @Override
    public void closeAllItems() {
        if (this.mode == Attributes.Mode.Multiple) {
            this.mOpenPositions.clear();
        } else {
            this.mOpenPosition = -1;
        }
        for (SwipeViewLayout s : this.mShownLayouts) {
            s.close();
        }
    }

    @Override
    public void removeShownLayouts(SwipeViewLayout layout) {
        this.mShownLayouts.remove((Object)layout);
    }

    @Override
    public List<Integer> getOpenItems() {
        if (this.mode == Attributes.Mode.Multiple) {
            return new ArrayList<Integer>(this.mOpenPositions);
        }
        return Collections.singletonList(this.mOpenPosition);
    }

    @Override
    public List<SwipeViewLayout> getOpenLayouts() {
        return new ArrayList<SwipeViewLayout>(this.mShownLayouts);
    }

    @Override
    public boolean isOpen(int position) {
        if (this.mode == Attributes.Mode.Multiple) {
            return this.mOpenPositions.contains(position);
        }
        return this.mOpenPosition == position;
    }

    class SwipeMemory
    implements SwipeViewLayout.SwipeListener {
        private int position;

        SwipeMemory(int position) {
            this.position = position;
        }

        @Override
        public void onClose(SwipeViewLayout layout) {
            if (SwipeItemMangerImpl.this.mode == Attributes.Mode.Multiple) {
                SwipeItemMangerImpl.this.mOpenPositions.remove(this.position);
            } else {
                SwipeItemMangerImpl.this.mOpenPosition = -1;
            }
        }

        @Override
        public void onUpdate(SwipeViewLayout layout, int leftOffset, int topOffset) {
        }

        @Override
        public void onHandRelease(SwipeViewLayout layout, float xvel, float yvel) {
        }

        @Override
        public void onStartOpen(SwipeViewLayout layout) {
            if (SwipeItemMangerImpl.this.mode == Attributes.Mode.Single) {
                SwipeItemMangerImpl.this.closeAllExcept(layout);
            }
        }

        @Override
        public void onOpen(SwipeViewLayout layout) {
            if (SwipeItemMangerImpl.this.mode == Attributes.Mode.Multiple) {
                SwipeItemMangerImpl.this.mOpenPositions.add(this.position);
            } else {
                SwipeItemMangerImpl.this.closeAllExcept(layout);
                SwipeItemMangerImpl.this.mOpenPosition = this.position;
            }
        }

        @Override
        public void onStartClose(SwipeViewLayout layout) {
        }

        public void setPosition(int position) {
            this.position = position;
        }
    }

    class OnLayoutListener
    implements SwipeViewLayout.OnLayout {
        private int position;

        OnLayoutListener(int position) {
            this.position = position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        @Override
        public void onLayout(SwipeViewLayout v) {
            if (SwipeItemMangerImpl.this.isOpen(this.position)) {
                v.open(false, false);
            } else {
                v.close(false, false);
            }
        }
    }

    class ValueBox {
        OnLayoutListener onLayoutListener;
        SwipeMemory swipeMemory;
        int position;

        ValueBox(int position, SwipeMemory swipeMemory, OnLayoutListener onLayoutListener) {
            this.swipeMemory = swipeMemory;
            this.onLayoutListener = onLayoutListener;
            this.position = position;
        }
    }
}

