/*
 * Decompiled with CFR 0.152.
 */
package com.anthony.ultimateswipetool.dialogFragment;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.anthony.ultimateswipetool.R;

public class SwipeDialogLayout
extends FrameLayout
implements View.OnTouchListener {
    private int mSlop;
    private int mMinFlingVelocity;
    private int mMaxFlingVelocity;
    private long mAnimationTime;
    private View mView;
    private DismissCallbacks mCallbacks;
    private int mViewWidth = 1;
    private float mDownX;
    private float mDownY;
    private boolean mSwiping;
    private int mSwipingSlop;
    private Object mToken;
    private VelocityTracker mVelocityTracker;
    private float mTranslationX;
    private boolean mTiltEnabled = true;
    private View mContentView;
    private Context mContext;

    public SwipeDialogLayout(Context context) {
        this(context, null);
    }

    public SwipeDialogLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.UST_activity_style);
    }

    public SwipeDialogLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init();
    }

    private void init() {
        ViewConfiguration vc = ViewConfiguration.get((Context)this.mContext);
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity() * 16;
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.mAnimationTime = this.mContext.getResources().getInteger(0x10E0000);
        this.setOnTouchListener(this);
    }

    public void setTiltEnabled(boolean tiltEnabled) {
        this.mTiltEnabled = tiltEnabled;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        motionEvent.offsetLocation(this.mTranslationX, 0.0f);
        if (this.mViewWidth < 2) {
            this.mViewWidth = this.mView.getWidth();
        }
        switch (motionEvent.getActionMasked()) {
            case 0: {
                this.mDownX = motionEvent.getRawX();
                this.mDownY = motionEvent.getRawY();
                if (this.mCallbacks.canDismiss(this.mToken)) {
                    this.mVelocityTracker = VelocityTracker.obtain();
                    this.mVelocityTracker.addMovement(motionEvent);
                }
                return false;
            }
            case 1: {
                boolean dismissRight;
                if (this.mVelocityTracker == null) break;
                float deltaX = motionEvent.getRawX() - this.mDownX;
                this.mVelocityTracker.addMovement(motionEvent);
                this.mVelocityTracker.computeCurrentVelocity(1000);
                float velocityX = this.mVelocityTracker.getXVelocity();
                float absVelocityX = Math.abs(velocityX);
                float absVelocityY = Math.abs(this.mVelocityTracker.getYVelocity());
                boolean dismiss = false;
                if (Math.abs(deltaX) > (float)(this.mViewWidth / 2) && this.mSwiping) {
                    dismiss = true;
                    dismissRight = deltaX > 0.0f;
                } else if ((float)this.mMinFlingVelocity <= absVelocityX && absVelocityX <= (float)this.mMaxFlingVelocity && absVelocityY < absVelocityX && absVelocityY < absVelocityX && this.mSwiping) {
                    dismiss = velocityX < 0.0f == deltaX < 0.0f;
                    dismissRight = this.mVelocityTracker.getXVelocity() > 0.0f;
                } else {
                    dismissRight = false;
                }
                if (dismiss) {
                    this.mView.animate().translationX(dismissRight ? (float)this.mViewWidth : (float)(-this.mViewWidth)).rotation(this.mTiltEnabled ? (float)(dismissRight ? 45 : -45) : 0.0f).alpha(0.0f).setDuration(this.mAnimationTime).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            SwipeDialogLayout.this.performDismiss(dismissRight);
                        }
                    });
                } else if (this.mSwiping) {
                    this.mView.animate().translationX(0.0f).rotation(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
                }
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                this.mTranslationX = 0.0f;
                this.mDownX = 0.0f;
                this.mDownY = 0.0f;
                this.mSwiping = false;
                break;
            }
            case 3: {
                if (this.mVelocityTracker == null) break;
                this.mView.animate().translationX(0.0f).rotation(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                this.mTranslationX = 0.0f;
                this.mDownX = 0.0f;
                this.mDownY = 0.0f;
                this.mSwiping = false;
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.addMovement(motionEvent);
                float deltaX = motionEvent.getRawX() - this.mDownX;
                float deltaY = motionEvent.getRawY() - this.mDownY;
                if (Math.abs(deltaX) > (float)this.mSlop && Math.abs(deltaY) < Math.abs(deltaX) / 2.0f) {
                    this.mSwiping = true;
                    this.mSwipingSlop = deltaX > 0.0f ? this.mSlop : -this.mSlop;
                    this.mView.getParent().requestDisallowInterceptTouchEvent(true);
                    MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                    cancelEvent.setAction(3 | motionEvent.getActionIndex() << 8);
                    this.mView.onTouchEvent(cancelEvent);
                    cancelEvent.recycle();
                }
                if (!this.mSwiping) break;
                this.mTranslationX = deltaX;
                this.mView.setTranslationX(deltaX - (float)this.mSwipingSlop);
                this.mView.setRotation(this.mTiltEnabled ? 45.0f * deltaX / (float)this.mViewWidth : 0.0f);
                this.mView.setAlpha(Math.max(0.0f, Math.min(1.0f, 1.0f - 2.0f * Math.abs(deltaX) / (float)this.mViewWidth)));
                return true;
            }
        }
        return false;
    }

    private void performDismiss(final boolean toRight) {
        final ViewGroup.LayoutParams lp = this.mView.getLayoutParams();
        final int originalHeight = this.mView.getHeight();
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{originalHeight, 1}).setDuration(this.mAnimationTime);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SwipeDialogLayout.this.mCallbacks.onDismiss(SwipeDialogLayout.this.mView, toRight, SwipeDialogLayout.this.mToken);
                SwipeDialogLayout.this.mView.setAlpha(1.0f);
                SwipeDialogLayout.this.mView.setTranslationX(0.0f);
                SwipeDialogLayout.this.mView.setRotation(0.0f);
                lp.height = originalHeight;
                SwipeDialogLayout.this.mView.setLayoutParams(lp);
            }
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                lp.height = (Integer)valueAnimator.getAnimatedValue();
                SwipeDialogLayout.this.mView.setLayoutParams(lp);
            }
        });
        animator.start();
    }

    public void addSwipeListener(View decorView, Object token, DismissCallbacks callbacks) {
        this.mCallbacks = callbacks;
        this.mView = decorView;
        this.mToken = token;
    }

    public static interface DismissCallbacks {
        public boolean canDismiss(Object var1);

        public void onDismiss(View var1, boolean var2, Object var3);
    }
}

