/*
 * Decompiled with CFR 0.152.
 */
package com.anthony.ultimateswipetool.dialogFragment;

import android.content.Context;
import android.support.v4.app.DialogFragment;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.anthony.ultimateswipetool.SwipeHelper;
import com.anthony.ultimateswipetool.dialogFragment.SwipeDialogLayout;

public class SwipeDialogFragment
extends DialogFragment {
    private boolean mSwipeable = true;
    private boolean mTiltEnabled = true;
    private boolean mSwipeLayoutGenerated = false;
    private SwipeDialogLayout swipeDialogLayout;

    public void setSwipeable(boolean swipeable) {
        this.mSwipeable = swipeable;
    }

    public boolean isSwipeable() {
        return this.mSwipeable;
    }

    public void setTiltEnabled(boolean tiltEnabled) {
        this.mTiltEnabled = tiltEnabled;
        if (this.swipeDialogLayout != null) {
            this.swipeDialogLayout.setTiltEnabled(tiltEnabled);
        }
    }

    public boolean isTiltEnabled() {
        return this.mTiltEnabled;
    }

    public boolean onSwipedAway(boolean toRight) {
        return false;
    }

    public void onStart() {
        super.onStart();
        if (!this.mSwipeLayoutGenerated && this.getShowsDialog()) {
            Window window = this.getDialog().getWindow();
            ViewGroup decorView = (ViewGroup)window.getDecorView();
            this.swipeDialogLayout = new SwipeDialogLayout((Context)this.getActivity());
            SwipeHelper.replaceContentView(window, (ViewGroup)this.swipeDialogLayout);
            this.swipeDialogLayout.addSwipeListener((View)decorView, "layout", new SwipeDialogLayout.DismissCallbacks(){

                @Override
                public boolean canDismiss(Object token) {
                    return SwipeDialogFragment.this.isCancelable() && SwipeDialogFragment.this.mSwipeable;
                }

                @Override
                public void onDismiss(View view, boolean toRight, Object token) {
                    if (!SwipeDialogFragment.this.onSwipedAway(toRight)) {
                        SwipeDialogFragment.this.dismiss();
                    }
                }
            });
            this.swipeDialogLayout.setTiltEnabled(this.mTiltEnabled);
            this.swipeDialogLayout.setClickable(true);
            this.mSwipeLayoutGenerated = true;
        }
    }
}

