/*
 * Decompiled with CFR 0.152.
 */
package com.anthony.ultimateswipetool.cards;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import com.anthony.ultimateswipetool.R;
import com.anthony.ultimateswipetool.cards.SwipeCardsHelper;
import java.util.Random;

public class SwipeCards
extends ViewGroup {
    public static final int SWIPE_DIRECTION_BOTH = 0;
    public static final int SWIPE_DIRECTION_ONLY_LEFT = 1;
    public static final int SWIPE_DIRECTION_ONLY_RIGHT = 2;
    public static final int DEFAULT_ANIMATION_DURATION = 300;
    public static final int DEFAULT_STACK_SIZE = 3;
    public static final int DEFAULT_STACK_ROTATION = 8;
    public static final float DEFAULT_SWIPE_ROTATION = 30.0f;
    public static final float DEFAULT_SWIPE_OPACITY = 1.0f;
    public static final float DEFAULT_SCALE_FACTOR = 1.0f;
    public static final boolean DEFAULT_DISABLE_HW_ACCELERATION = true;
    private static final String KEY_SUPER_STATE = "superState";
    private static final String KEY_CURRENT_INDEX = "currentIndex";
    private Adapter mAdapter;
    private Random mRandom;
    private int mAllowedSwipeDirections;
    private int mAnimationDuration;
    private int mCurrentViewIndex;
    private int mNumberOfStackedViews;
    private int mViewSpacing;
    private int mViewRotation;
    private float mSwipeRotation;
    private float mSwipeOpacity;
    private float mScaleFactor;
    private boolean mDisableHwAcceleration;
    private boolean mIsFirstLayout = true;
    private View mTopView;
    private SwipeCardsHelper mSwipeCardsHelper;
    private DataSetObserver mDataObserver;
    private SwipeCardsListener mListener;
    private SwipeProgressListener mProgressListener;

    public SwipeCards(Context context) {
        this(context, null);
    }

    public SwipeCards(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeCards(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.readAttributes(attrs);
        this.initialize();
    }

    private void readAttributes(AttributeSet attributeSet) {
        TypedArray attrs = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.UST_cards);
        try {
            this.mAllowedSwipeDirections = attrs.getInt(R.styleable.UST_cards_UST_allowed_swipe_directions, 0);
            this.mAnimationDuration = attrs.getInt(R.styleable.UST_cards_UST_animation_duration, 300);
            this.mNumberOfStackedViews = attrs.getInt(R.styleable.UST_cards_UST_stack_size, 3);
            this.mViewSpacing = attrs.getDimensionPixelSize(R.styleable.UST_cards_UST_stack_spacing, this.getResources().getDimensionPixelSize(R.dimen.default_stack_spacing));
            this.mViewRotation = attrs.getInt(R.styleable.UST_cards_UST_stack_rotation, 8);
            this.mSwipeRotation = attrs.getFloat(R.styleable.UST_cards_UST_swipe_rotation, 30.0f);
            this.mSwipeOpacity = attrs.getFloat(R.styleable.UST_cards_UST_swipe_opacity, 1.0f);
            this.mScaleFactor = attrs.getFloat(R.styleable.UST_cards_UST_scale_factor, 1.0f);
            this.mDisableHwAcceleration = attrs.getBoolean(R.styleable.UST_cards_UST_disable_hw_acceleration, true);
        }
        finally {
            attrs.recycle();
        }
    }

    private void initialize() {
        this.mRandom = new Random();
        this.setClipToPadding(false);
        this.setClipChildren(false);
        this.mSwipeCardsHelper = new SwipeCardsHelper(this);
        this.mSwipeCardsHelper.setAnimationDuration(this.mAnimationDuration);
        this.mSwipeCardsHelper.setRotation(this.mSwipeRotation);
        this.mSwipeCardsHelper.setOpacityEnd(this.mSwipeOpacity);
        this.mDataObserver = new DataSetObserver(){

            public void onChanged() {
                super.onChanged();
                SwipeCards.this.invalidate();
                SwipeCards.this.requestLayout();
            }
        };
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_SUPER_STATE, super.onSaveInstanceState());
        bundle.putInt(KEY_CURRENT_INDEX, this.mCurrentViewIndex - this.getChildCount());
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mCurrentViewIndex = bundle.getInt(KEY_CURRENT_INDEX);
            state = bundle.getParcelable(KEY_SUPER_STATE);
        }
        super.onRestoreInstanceState(state);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mAdapter == null || this.mAdapter.isEmpty()) {
            this.mCurrentViewIndex = 0;
            this.removeAllViewsInLayout();
            return;
        }
        for (int x = this.getChildCount(); x < this.mNumberOfStackedViews && this.mCurrentViewIndex < this.mAdapter.getCount(); ++x) {
            this.addNextView();
        }
        this.reorderItems();
        this.mIsFirstLayout = false;
    }

    private void addNextView() {
        if (this.mCurrentViewIndex < this.mAdapter.getCount()) {
            View bottomView = this.mAdapter.getView(this.mCurrentViewIndex, null, (ViewGroup)this);
            bottomView.setTag(R.id.new_view, (Object)true);
            if (!this.mDisableHwAcceleration) {
                bottomView.setLayerType(2, null);
            }
            if (this.mViewRotation > 0) {
                bottomView.setRotation((float)(this.mRandom.nextInt(this.mViewRotation) - this.mViewRotation / 2));
            }
            int width = this.getWidth() - (this.getPaddingLeft() + this.getPaddingRight());
            int height = this.getHeight() - (this.getPaddingTop() + this.getPaddingBottom());
            ViewGroup.LayoutParams params = bottomView.getLayoutParams();
            if (params == null) {
                params = new ViewGroup.LayoutParams(-2, -2);
            }
            int measureSpecWidth = Integer.MIN_VALUE;
            int measureSpecHeight = Integer.MIN_VALUE;
            if (params.width == -1) {
                measureSpecWidth = 0x40000000;
            }
            if (params.height == -1) {
                measureSpecHeight = 0x40000000;
            }
            bottomView.measure(measureSpecWidth | width, measureSpecHeight | height);
            this.addViewInLayout(bottomView, 0, params, true);
            ++this.mCurrentViewIndex;
        }
    }

    private void reorderItems() {
        for (int x = 0; x < this.getChildCount(); ++x) {
            View childView = this.getChildAt(x);
            int topViewIndex = this.getChildCount() - 1;
            int distanceToViewAbove = topViewIndex * this.mViewSpacing - x * this.mViewSpacing;
            int newPositionX = (this.getWidth() - childView.getMeasuredWidth()) / 2;
            int newPositionY = distanceToViewAbove + this.getPaddingTop();
            childView.layout(newPositionX, this.getPaddingTop(), newPositionX + childView.getMeasuredWidth(), this.getPaddingTop() + childView.getMeasuredHeight());
            if (Build.VERSION.SDK_INT >= 21) {
                childView.setTranslationZ((float)x);
            }
            boolean isNewView = (Boolean)childView.getTag(R.id.new_view);
            float scaleFactor = (float)Math.pow(this.mScaleFactor, this.getChildCount() - x);
            if (x == topViewIndex) {
                this.mSwipeCardsHelper.unregisterObservedView();
                this.mTopView = childView;
                this.mSwipeCardsHelper.registerObservedView(this.mTopView, newPositionX, newPositionY);
            }
            if (!this.mIsFirstLayout) {
                if (isNewView) {
                    childView.setTag(R.id.new_view, (Object)false);
                    childView.setAlpha(0.0f);
                    childView.setY((float)newPositionY);
                    childView.setScaleY(scaleFactor);
                    childView.setScaleX(scaleFactor);
                }
                childView.animate().y((float)newPositionY).scaleX(scaleFactor).scaleY(scaleFactor).alpha(1.0f).setDuration((long)this.mAnimationDuration);
                continue;
            }
            childView.setTag(R.id.new_view, (Object)false);
            childView.setY((float)newPositionY);
            childView.setScaleY(scaleFactor);
            childView.setScaleX(scaleFactor);
        }
    }

    private void removeTopView() {
        if (this.mTopView != null) {
            this.removeView(this.mTopView);
            this.mTopView = null;
        }
        if (this.getChildCount() == 0 && this.mListener != null) {
            this.mListener.onCardsEmpty();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    public void onSwipeStart() {
        if (this.mProgressListener != null) {
            this.mProgressListener.onSwipeStart(this.getCurrentPosition());
        }
    }

    public void onSwipeProgress(float progress) {
        if (this.mProgressListener != null) {
            this.mProgressListener.onSwipeProgress(this.getCurrentPosition(), progress);
        }
    }

    public void onSwipeEnd() {
        if (this.mProgressListener != null) {
            this.mProgressListener.onSwipeEnd(this.getCurrentPosition());
        }
    }

    public void onViewSwipedToLeft() {
        if (this.mListener != null) {
            this.mListener.onViewSwipedToLeft(this.getCurrentPosition());
        }
        this.removeTopView();
    }

    public void onViewSwipedToRight() {
        if (this.mListener != null) {
            this.mListener.onViewSwipedToRight(this.getCurrentPosition());
        }
        this.removeTopView();
    }

    public int getCurrentPosition() {
        return this.mCurrentViewIndex - this.getChildCount();
    }

    public Adapter getAdapter() {
        return this.mAdapter;
    }

    public void setAdapter(Adapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataObserver);
        }
        this.mAdapter = adapter;
        this.mAdapter.registerDataSetObserver(this.mDataObserver);
    }

    public int getAllowedSwipeDirections() {
        return this.mAllowedSwipeDirections;
    }

    public void setAllowedSwipeDirections(int directions) {
        this.mAllowedSwipeDirections = directions;
    }

    public void setListener(@Nullable SwipeCardsListener listener) {
        this.mListener = listener;
    }

    public void setSwipeProgressListener(@Nullable SwipeProgressListener listener) {
        this.mProgressListener = listener;
    }

    public View getTopView() {
        return this.mTopView;
    }

    public void swipeTopViewToRight() {
        if (this.getChildCount() == 0) {
            return;
        }
        this.mSwipeCardsHelper.swipeViewToRight();
    }

    public void swipeTopViewToLeft() {
        if (this.getChildCount() == 0) {
            return;
        }
        this.mSwipeCardsHelper.swipeViewToLeft();
    }

    public void resetStack() {
        this.mCurrentViewIndex = 0;
        this.removeAllViewsInLayout();
        this.requestLayout();
    }

    public static interface SwipeProgressListener {
        public void onSwipeStart(int var1);

        public void onSwipeProgress(int var1, float var2);

        public void onSwipeEnd(int var1);
    }

    public static interface SwipeCardsListener {
        public void onViewSwipedToLeft(int var1);

        public void onViewSwipedToRight(int var1);

        public void onCardsEmpty();
    }
}

