/*
 * Decompiled with CFR 0.152.
 */
package com.anthony.ultimateswipetool;

import android.animation.Animator;
import android.app.Activity;
import android.app.ActivityOptions;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.anthony.ultimateswipetool.activity.SwipeBackLayout;
import java.lang.reflect.Method;

public class SwipeHelper {
    private Activity mActivity;
    private SwipeBackLayout mSwipeBackLayout;

    public SwipeHelper(Activity activity) {
        this.mActivity = activity;
    }

    public static void replaceContentView(Window window, ViewGroup newContentView) {
        ViewGroup decorView = (ViewGroup)window.getDecorView();
        View content = decorView.getChildAt(0);
        decorView.removeView(content);
        newContentView.addView(content);
        decorView.addView((View)newContentView);
    }

    public void onActivityCreate() {
        this.mActivity.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mActivity.getWindow().getDecorView().setBackgroundDrawable(null);
        this.mSwipeBackLayout = new SwipeBackLayout((Context)this.mActivity);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.mSwipeBackLayout.setLayoutParams(params);
        this.mSwipeBackLayout.addSwipeListener(new SwipeBackLayout.SwipeListener(){

            @Override
            public void onScrollStateChange(int state, float scrollPercent) {
            }

            @Override
            public void onEdgeTouch(int edgeFlag) {
                SwipeHelper.convertActivityToTranslucent(SwipeHelper.this.mActivity);
            }

            @Override
            public void onScrollOverThreshold() {
            }
        });
    }

    public void onPostCreate() {
        this.mSwipeBackLayout.attachToActivity(this.mActivity);
    }

    public View findViewById(int id2) {
        if (this.mSwipeBackLayout != null) {
            return this.mSwipeBackLayout.findViewById(id2);
        }
        return null;
    }

    public SwipeBackLayout getSwipeBackLayout() {
        return this.mSwipeBackLayout;
    }

    public static void convertActivityFromTranslucent(Activity activity) {
        try {
            Method method = Activity.class.getDeclaredMethod("convertFromTranslucent", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)activity, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void convertActivityToTranslucent(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            SwipeHelper.convertActivityToTranslucentAfterL(activity);
        } else {
            SwipeHelper.convertActivityToTranslucentBeforeL(activity);
        }
    }

    public static void convertActivityToTranslucentBeforeL(Activity activity) {
        try {
            Class<?>[] classes = Activity.class.getDeclaredClasses();
            Class<?> translucentConversionListenerClazz = null;
            for (Class<?> clazz : classes) {
                if (!clazz.getSimpleName().contains("TranslucentConversionListener")) continue;
                translucentConversionListenerClazz = clazz;
            }
            Method method = Activity.class.getDeclaredMethod("convertToTranslucent", translucentConversionListenerClazz);
            method.setAccessible(true);
            method.invoke((Object)activity, new Object[]{null});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void convertActivityToTranslucentAfterL(Activity activity) {
        try {
            Method getActivityOptions = Activity.class.getDeclaredMethod("getActivityOptions", new Class[0]);
            getActivityOptions.setAccessible(true);
            Object options = getActivityOptions.invoke((Object)activity, new Object[0]);
            Class<?>[] classes = Activity.class.getDeclaredClasses();
            Class<?> translucentConversionListenerClazz = null;
            for (Class<?> clazz : classes) {
                if (!clazz.getSimpleName().contains("TranslucentConversionListener")) continue;
                translucentConversionListenerClazz = clazz;
            }
            Method convertToTranslucent = Activity.class.getDeclaredMethod("convertToTranslucent", translucentConversionListenerClazz, ActivityOptions.class);
            convertToTranslucent.setAccessible(true);
            convertToTranslucent.invoke((Object)activity, null, options);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static abstract class AnimationEndListener
    implements Animator.AnimatorListener {
        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }
}

