/*
 * Decompiled with CFR 0.152.
 */
package com.anthony.ultimateswipetool.dialogFragment;

import android.content.Context;
import android.support.v4.app.DialogFragment;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.anthony.ultimateswipetool.SwipeHelper;
import com.anthony.ultimateswipetool.dialogFragment.SwipeLayout;

public class SwipeDialogFragment
extends DialogFragment {
    private boolean mSwipeable = true;
    private boolean mTiltEnabled = true;
    private boolean mSwipeLayoutGenerated = false;
    private SwipeLayout swipeLayout;

    public void setSwipeable(boolean swipeable) {
        this.mSwipeable = swipeable;
    }

    public boolean isSwipeable() {
        return this.mSwipeable;
    }

    public void setTiltEnabled(boolean tiltEnabled) {
        this.mTiltEnabled = tiltEnabled;
        if (this.swipeLayout != null) {
            this.swipeLayout.setTiltEnabled(tiltEnabled);
        }
    }

    public boolean isTiltEnabled() {
        return this.mTiltEnabled;
    }

    public boolean onSwipedAway(boolean toRight) {
        return false;
    }

    public void onStart() {
        super.onStart();
        if (!this.mSwipeLayoutGenerated && this.getShowsDialog()) {
            Window window = this.getDialog().getWindow();
            ViewGroup decorView = (ViewGroup)window.getDecorView();
            this.swipeLayout = new SwipeLayout((Context)this.getActivity());
            SwipeHelper.replaceContentView(window, (ViewGroup)this.swipeLayout);
            this.swipeLayout.addSwipeListener((View)decorView, "layout", new SwipeLayout.DismissCallbacks(){

                @Override
                public boolean canDismiss(Object token) {
                    return SwipeDialogFragment.this.isCancelable() && SwipeDialogFragment.this.mSwipeable;
                }

                @Override
                public void onDismiss(View view, boolean toRight, Object token) {
                    if (!SwipeDialogFragment.this.onSwipedAway(toRight)) {
                        SwipeDialogFragment.this.dismiss();
                    }
                }
            });
            this.swipeLayout.setTiltEnabled(this.mTiltEnabled);
            this.swipeLayout.setClickable(true);
            this.mSwipeLayoutGenerated = true;
        }
    }
}

