/*
 * Decompiled with CFR 0.152.
 */
package com.anrisoftware.globalpom.fileresourcemanager;

import com.anrisoftware.globalpom.fileresourcemanager.FileResourceException;
import com.anrisoftware.globalpom.fileresourcemanager.Resource;
import com.anrisoftware.globalpom.fileresourcemanager.ResourceSaver;
import com.anrisoftware.globalpom.log.AbstractLogger;
import java.io.File;
import javax.inject.Singleton;

@Singleton
class ResourceSaverLogger
extends AbstractLogger {
    public ResourceSaverLogger() {
        super(ResourceSaver.class);
    }

    FileResourceException errorStartManager(Exception e, File dir) {
        return (FileResourceException)this.logException(new FileResourceException((Object)_.ERROR_START_MANAGER, (Throwable)e).add((Object)_.STORE_DIRECTORY, (Object)dir), (Object)_.ERROR_START_MANAGER1, new Object[]{dir});
    }

    FileResourceException errorStartTransaction(Exception e, File dir) {
        return (FileResourceException)this.logException(new FileResourceException((Object)_.ERROR_START_TRANSACTION, (Throwable)e).add((Object)_.STORE_DIRECTORY, (Object)dir), (Object)_.ERROR_START_TRANSACTION1, new Object[]{dir});
    }

    FileResourceException errorRollbackTransaction(Exception e, String id) {
        return (FileResourceException)this.logException(new FileResourceException((Object)_.ERROR_ROLLBACK_TRANSACTION, (Throwable)e).add((Object)_.ID, (Object)id), (Object)_.ERROR_ROLLBACK_TRANSACTION1, new Object[]{id});
    }

    FileResourceException errorStopManager(Exception e, String dir) {
        return (FileResourceException)this.logException(new FileResourceException((Object)_.ERROR_STOP_MANAGER, (Throwable)e).add((Object)_.STORE_DIRECTORY, (Object)dir), (Object)_.ERROR_STOP_MANAGER1, new Object[]{dir});
    }

    FileResourceException errorSave(Throwable e, Resource[] resources, File dir) {
        return (FileResourceException)this.logException(new FileResourceException((Object)_.ERROR_SAVE_RESOURCES, e).add((Object)_.RESOURCES, (Object)resources).add((Object)_.STORE_DIRECTORY, (Object)dir), (Object)_.ERROR_SAVE_RESOURCES1, new Object[]{dir});
    }

    public FileResourceException errorSaveResource(Exception e, Resource resource, File dir) {
        return (FileResourceException)this.logException(new FileResourceException((Object)_.ERROR_SAVE_RESOURCE, (Throwable)e).add((Object)_.RESOURCE, (Object)resource).add((Object)_.STORE_DIRECTORY, (Object)dir), (Object)_.ERROR_SAVE_RESOURCE1, new Object[]{resource.getName(), dir});
    }

    private static enum _ {
        STORE_DIRECTORY("directory"),
        ID("transaction ID"),
        RESOURCES("resources"),
        RESOURCE("resource"),
        ERROR_START_MANAGER1("Error start file resource manager in store directory '{}'."),
        ERROR_START_MANAGER("Error start file resource manager"),
        ERROR_START_TRANSACTION("Error start transaction"),
        ERROR_START_TRANSACTION1("Error start transaction in store directory '{}'."),
        ERROR_ROLLBACK_TRANSACTION("Error rollback transaction"),
        ERROR_ROLLBACK_TRANSACTION1("Error rollback transaction ID {}."),
        ERROR_STOP_MANAGER1("Error stop file resource manager in store directory '{}'."),
        ERROR_STOP_MANAGER("Error stop file resource manager"),
        ERROR_SAVE_RESOURCES1("Error save resources in store directory '{}'."),
        ERROR_SAVE_RESOURCES("Error save resources"),
        ERROR_SAVE_RESOURCE1("Error save resource '{}' in store directory '{}'."),
        ERROR_SAVE_RESOURCE("Error save resource");

        private String name;

        private _(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

