/*
 * Decompiled with CFR 0.152.
 */
package com.anrisoftware.globalpom.fileresourcemanager;

import com.anrisoftware.globalpom.fileresourcemanager.FileResourceException;
import com.anrisoftware.globalpom.fileresourcemanager.FileResourceManagerProvider;
import com.anrisoftware.globalpom.fileresourcemanager.Resource;
import com.anrisoftware.globalpom.fileresourcemanager.ResourceSaverLogger;
import com.google.inject.assistedinject.Assisted;
import java.io.File;
import java.io.OutputStream;
import javax.inject.Inject;
import org.apache.commons.transaction.file.FileResourceManager;
import org.apache.commons.transaction.file.ResourceManagerException;
import org.apache.commons.transaction.file.ResourceManagerSystemException;

public class ResourceSaver {
    private final File storeDir;
    @Inject
    private ResourceSaverLogger log;
    private FileResourceManager manager;

    @Inject
    ResourceSaver(@Assisted File storeDir) {
        this.storeDir = storeDir;
    }

    @Inject
    void FileResourceManagerProvider(FileResourceManagerProvider manager) {
        manager.setStoreDir(this.storeDir);
        this.manager = manager.get();
    }

    public void saveResource(Resource ... resources) throws FileResourceException {
        this.startManager();
        String id = this.startTransaction();
        try {
            this.saveResources(id, resources);
            this.manager.commitTransaction((Object)id);
        }
        catch (Throwable e) {
            this.rollbackTransaction(this.manager, id);
            this.stopManager(this.manager);
            new File(this.manager.getWorkDir()).delete();
            throw this.log.errorSave(e, resources, this.storeDir);
        }
        this.stopManager(this.manager);
        new File(this.manager.getWorkDir()).delete();
    }

    private void startManager() throws FileResourceException {
        try {
            this.manager.start();
        }
        catch (ResourceManagerSystemException e) {
            throw this.log.errorStartManager((Exception)((Object)e), this.storeDir);
        }
    }

    private String startTransaction() throws FileResourceException {
        try {
            String id = this.manager.generatedUniqueTxId();
            this.manager.startTransaction((Object)id);
            return id;
        }
        catch (ResourceManagerSystemException e) {
            throw this.log.errorStartTransaction((Exception)((Object)e), this.storeDir);
        }
        catch (ResourceManagerException e) {
            throw this.log.errorStartTransaction((Exception)((Object)e), this.storeDir);
        }
    }

    private void saveResources(String id, Resource[] resources) throws ResourceManagerException, FileResourceException {
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            this.saveResource(this.manager, id, resource);
            ++n2;
        }
    }

    private void saveResource(FileResourceManager manager, String id, Resource resource) throws ResourceManagerException, FileResourceException {
        String projectId = resource.getName();
        OutputStream projectStream = manager.writeResource((Object)id, (Object)projectId);
        this.saveResource(projectStream, resource);
    }

    private void saveResource(OutputStream stream, Resource resource) throws FileResourceException {
        try {
            resource.save(stream);
        }
        catch (Exception e) {
            throw this.log.errorSaveResource(e, resource, this.storeDir);
        }
    }

    private void rollbackTransaction(FileResourceManager manager, String id) throws FileResourceException {
        try {
            manager.rollbackTransaction((Object)id);
        }
        catch (ResourceManagerException e) {
            throw this.log.errorRollbackTransaction((Exception)((Object)e), id);
        }
    }

    private void stopManager(FileResourceManager manager) throws FileResourceException {
        try {
            manager.stop(0);
        }
        catch (ResourceManagerSystemException e) {
            throw this.log.errorStopManager((Exception)((Object)e), manager.getStoreDir());
        }
    }
}

