/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.ThrowablePredicate;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public interface Predicate<T> {
    public boolean test(T var1);

    public static class Util {
        private Util() {
        }

        public static <T> Predicate<T> and(final @NotNull Predicate<? super T> p1, final @NotNull Predicate<? super T> p2) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            return new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    return p1.test(value) && p2.test(value);
                }
            };
        }

        public static <T> Predicate<T> and(final @NotNull Predicate<? super T> p1, final @NotNull Predicate<? super T> p2, final Predicate<? super T> ... rest) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            Objects.requireNonNull(rest, "rest");
            Objects.requireNonNullElements(Arrays.asList(rest));
            return new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    boolean result;
                    boolean bl = result = p1.test(value) && p2.test(value);
                    if (!result) {
                        return false;
                    }
                    for (Predicate p : rest) {
                        if (p.test(value)) continue;
                        return false;
                    }
                    return true;
                }
            };
        }

        public static <T> Predicate<T> or(final @NotNull Predicate<? super T> p1, final @NotNull Predicate<? super T> p2) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            return new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    return p1.test(value) || p2.test(value);
                }
            };
        }

        public static <T> Predicate<T> or(final @NotNull Predicate<? super T> p1, final @NotNull Predicate<? super T> p2, final Predicate<? super T> ... rest) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            Objects.requireNonNull(rest, "rest");
            Objects.requireNonNullElements(Arrays.asList(rest));
            return new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    boolean result;
                    boolean bl = result = p1.test(value) || p2.test(value);
                    if (result) {
                        return true;
                    }
                    for (Predicate p : rest) {
                        if (!p.test(value)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        public static <T> Predicate<T> xor(final @NotNull Predicate<? super T> p1, final @NotNull Predicate<? super T> p2) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            return new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    return p1.test(value) ^ p2.test(value);
                }
            };
        }

        public static <T> Predicate<T> negate(final @NotNull Predicate<? super T> predicate) {
            Objects.requireNonNull(predicate);
            return new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    return !predicate.test(value);
                }
            };
        }

        public static <T> Predicate<T> notNull() {
            return new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    return value != null;
                }
            };
        }

        public static <T> Predicate<T> safe(@NotNull ThrowablePredicate<? super T, Throwable> throwablePredicate) {
            return Util.safe(throwablePredicate, false);
        }

        public static <T> Predicate<T> safe(final @NotNull ThrowablePredicate<? super T, Throwable> throwablePredicate, final boolean resultIfFailed) {
            Objects.requireNonNull(throwablePredicate);
            return new Predicate<T>(){

                @Override
                public boolean test(T value) {
                    try {
                        return throwablePredicate.test(value);
                    }
                    catch (Throwable throwable) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

