/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.ThrowableLongSupplier;
import org.jetbrains.annotations.NotNull;

public interface LongSupplier {
    public long getAsLong();

    public static class Util {
        private Util() {
        }

        public static LongSupplier safe(@NotNull ThrowableLongSupplier<Throwable> throwableSupplier) {
            return Util.safe(throwableSupplier, 0L);
        }

        public static LongSupplier safe(final @NotNull ThrowableLongSupplier<Throwable> throwableSupplier, final long resultIfFailed) {
            Objects.requireNonNull(throwableSupplier);
            return new LongSupplier(){

                @Override
                public long getAsLong() {
                    try {
                        return throwableSupplier.getAsLong();
                    }
                    catch (Throwable ex) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

