/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.ThrowableLongPredicate;
import org.jetbrains.annotations.NotNull;

public interface LongPredicate {
    public boolean test(long var1);

    public static class Util {
        private Util() {
        }

        public static LongPredicate and(final @NotNull LongPredicate p1, final @NotNull LongPredicate p2) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            return new LongPredicate(){

                @Override
                public boolean test(long value) {
                    return p1.test(value) && p2.test(value);
                }
            };
        }

        public static LongPredicate or(final @NotNull LongPredicate p1, final @NotNull LongPredicate p2) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            return new LongPredicate(){

                @Override
                public boolean test(long value) {
                    return p1.test(value) || p2.test(value);
                }
            };
        }

        public static LongPredicate xor(final @NotNull LongPredicate p1, final @NotNull LongPredicate p2) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            return new LongPredicate(){

                @Override
                public boolean test(long value) {
                    return p1.test(value) ^ p2.test(value);
                }
            };
        }

        public static LongPredicate negate(final @NotNull LongPredicate p1) {
            Objects.requireNonNull(p1);
            return new LongPredicate(){

                @Override
                public boolean test(long value) {
                    return !p1.test(value);
                }
            };
        }

        public static LongPredicate safe(@NotNull ThrowableLongPredicate<Throwable> throwablePredicate) {
            return Util.safe(throwablePredicate, false);
        }

        public static LongPredicate safe(final @NotNull ThrowableLongPredicate<Throwable> throwablePredicate, final boolean resultIfFailed) {
            Objects.requireNonNull(throwablePredicate);
            return new LongPredicate(){

                @Override
                public boolean test(long value) {
                    try {
                        return throwablePredicate.test(value);
                    }
                    catch (Throwable throwable) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

