/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.ThrowableLongConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LongConsumer {
    public void accept(long var1);

    public static class Util {
        private Util() {
        }

        public static LongConsumer andThen(final @NotNull LongConsumer c1, final @NotNull LongConsumer c2) {
            Objects.requireNonNull(c1, "c1");
            Objects.requireNonNull(c2, "c2");
            return new LongConsumer(){

                @Override
                public void accept(long value) {
                    c1.accept(value);
                    c2.accept(value);
                }
            };
        }

        public static LongConsumer safe(@NotNull ThrowableLongConsumer<Throwable> throwableConsumer) {
            return Util.safe(throwableConsumer, null);
        }

        public static LongConsumer safe(final @NotNull ThrowableLongConsumer<Throwable> throwableConsumer, final @Nullable LongConsumer onFailedConsumer) {
            Objects.requireNonNull(throwableConsumer);
            return new LongConsumer(){

                @Override
                public void accept(long value) {
                    block2: {
                        try {
                            throwableConsumer.accept(value);
                        }
                        catch (Throwable ex) {
                            if (onFailedConsumer == null) break block2;
                            onFailedConsumer.accept(value);
                        }
                    }
                }
            };
        }
    }
}

