/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.ThrowableIntFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IntFunction<R> {
    public R apply(int var1);

    public static class Util {
        private Util() {
        }

        public static <R> IntFunction<R> safe(@NotNull ThrowableIntFunction<? extends R, Throwable> throwableFunction) {
            return Util.safe(throwableFunction, null);
        }

        public static <R> IntFunction<R> safe(final @NotNull ThrowableIntFunction<? extends R, Throwable> throwableFunction, final @Nullable R resultIfFailed) {
            Objects.requireNonNull(throwableFunction);
            return new IntFunction<R>(){

                @Override
                public R apply(int value) {
                    try {
                        return throwableFunction.apply(value);
                    }
                    catch (Throwable throwable) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

