/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.DoubleConsumer;
import com.annimon.stream.function.IntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IndexedDoubleConsumer {
    public void accept(int var1, double var2);

    public static class Util {
        private Util() {
        }

        public static IndexedDoubleConsumer andThen(final @NotNull IndexedDoubleConsumer c1, final @NotNull IndexedDoubleConsumer c2) {
            Objects.requireNonNull(c1, "c1");
            Objects.requireNonNull(c2, "c2");
            return new IndexedDoubleConsumer(){

                @Override
                public void accept(int index, double value) {
                    c1.accept(index, value);
                    c2.accept(index, value);
                }
            };
        }

        public static IndexedDoubleConsumer accept(final @Nullable IntConsumer c1, final @Nullable DoubleConsumer c2) {
            return new IndexedDoubleConsumer(){

                @Override
                public void accept(int index, double value) {
                    if (c1 != null) {
                        c1.accept(index);
                    }
                    if (c2 != null) {
                        c2.accept(value);
                    }
                }
            };
        }
    }
}

