/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.ThrowableFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Function<T, R> {
    public R apply(T var1);

    public static class Util {
        private Util() {
        }

        public static <V, T, R> Function<V, R> compose(@NotNull Function<? super T, ? extends R> f1, @NotNull Function<? super V, ? extends T> f2) {
            Objects.requireNonNull(f1, "f1");
            Objects.requireNonNull(f2, "f2");
            return Util.andThen(f2, f1);
        }

        public static <T, R, V> Function<T, V> andThen(final @NotNull Function<? super T, ? extends R> f1, final @NotNull Function<? super R, ? extends V> f2) {
            Objects.requireNonNull(f1, "f1");
            Objects.requireNonNull(f2, "f2");
            return new Function<T, V>(){

                @Override
                public V apply(T t) {
                    return f2.apply(f1.apply(t));
                }
            };
        }

        public static <T, R> Function<T, R> safe(@NotNull ThrowableFunction<? super T, ? extends R, Throwable> throwableFunction) {
            return Util.safe(throwableFunction, null);
        }

        public static <T, R> Function<T, R> safe(final @NotNull ThrowableFunction<? super T, ? extends R, Throwable> throwableFunction, final @Nullable R resultIfFailed) {
            Objects.requireNonNull(throwableFunction);
            return new Function<T, R>(){

                @Override
                public R apply(T value) {
                    try {
                        return throwableFunction.apply(value);
                    }
                    catch (Throwable throwable) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

