/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.ThrowableDoubleConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DoubleConsumer {
    public void accept(double var1);

    public static class Util {
        private Util() {
        }

        public static DoubleConsumer andThen(final @NotNull DoubleConsumer c1, final @NotNull DoubleConsumer c2) {
            Objects.requireNonNull(c1, "c1");
            Objects.requireNonNull(c2, "c2");
            return new DoubleConsumer(){

                @Override
                public void accept(double value) {
                    c1.accept(value);
                    c2.accept(value);
                }
            };
        }

        public static DoubleConsumer safe(@NotNull ThrowableDoubleConsumer<Throwable> throwableConsumer) {
            return Util.safe(throwableConsumer, null);
        }

        public static DoubleConsumer safe(final @NotNull ThrowableDoubleConsumer<Throwable> throwableConsumer, final @Nullable DoubleConsumer onFailedConsumer) {
            Objects.requireNonNull(throwableConsumer);
            return new DoubleConsumer(){

                @Override
                public void accept(double value) {
                    block2: {
                        try {
                            throwableConsumer.accept(value);
                        }
                        catch (Throwable ex) {
                            if (onFailedConsumer == null) break block2;
                            onFailedConsumer.accept(value);
                        }
                    }
                }
            };
        }
    }
}

