/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import org.jetbrains.annotations.NotNull;

public interface BooleanPredicate {
    public boolean test(boolean var1);

    public static class Util {
        private Util() {
        }

        public static BooleanPredicate identity() {
            return new BooleanPredicate(){

                @Override
                public boolean test(boolean operand) {
                    return operand;
                }
            };
        }

        public static BooleanPredicate and(final @NotNull BooleanPredicate p1, final @NotNull BooleanPredicate p2) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            return new BooleanPredicate(){

                @Override
                public boolean test(boolean value) {
                    return p1.test(value) && p2.test(value);
                }
            };
        }

        public static BooleanPredicate or(final @NotNull BooleanPredicate p1, final @NotNull BooleanPredicate p2) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            return new BooleanPredicate(){

                @Override
                public boolean test(boolean value) {
                    return p1.test(value) || p2.test(value);
                }
            };
        }

        public static BooleanPredicate xor(final @NotNull BooleanPredicate p1, final @NotNull BooleanPredicate p2) {
            Objects.requireNonNull(p1, "predicate1");
            Objects.requireNonNull(p2, "predicate2");
            return new BooleanPredicate(){

                @Override
                public boolean test(boolean value) {
                    return p1.test(value) ^ p2.test(value);
                }
            };
        }

        public static BooleanPredicate negate(final @NotNull BooleanPredicate p1) {
            Objects.requireNonNull(p1);
            return new BooleanPredicate(){

                @Override
                public boolean test(boolean value) {
                    return !p1.test(value);
                }
            };
        }
    }
}

