/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.DoubleStream;
import com.annimon.stream.IntStream;
import com.annimon.stream.LongStream;
import com.annimon.stream.function.DoubleSupplier;
import com.annimon.stream.function.IntSupplier;
import com.annimon.stream.function.LongSupplier;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public final class RandomCompat {
    @NotNull
    private final Random random;

    public RandomCompat() {
        this.random = new Random();
    }

    public RandomCompat(long seed) {
        this.random = new Random(seed);
    }

    public RandomCompat(@NotNull Random random) {
        this.random = random;
    }

    @NotNull
    public Random getRandom() {
        return this.random;
    }

    @NotNull
    public IntStream ints(long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException();
        }
        if (streamSize == 0L) {
            return IntStream.empty();
        }
        return this.ints().limit(streamSize);
    }

    @NotNull
    public LongStream longs(long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException();
        }
        if (streamSize == 0L) {
            return LongStream.empty();
        }
        return this.longs().limit(streamSize);
    }

    @NotNull
    public DoubleStream doubles(long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException();
        }
        if (streamSize == 0L) {
            return DoubleStream.empty();
        }
        return this.doubles().limit(streamSize);
    }

    @NotNull
    public IntStream ints() {
        return IntStream.generate(new IntSupplier(){

            @Override
            public int getAsInt() {
                return RandomCompat.this.random.nextInt();
            }
        });
    }

    @NotNull
    public LongStream longs() {
        return LongStream.generate(new LongSupplier(){

            @Override
            public long getAsLong() {
                return RandomCompat.this.random.nextLong();
            }
        });
    }

    @NotNull
    public DoubleStream doubles() {
        return DoubleStream.generate(new DoubleSupplier(){

            @Override
            public double getAsDouble() {
                return RandomCompat.this.random.nextDouble();
            }
        });
    }

    @NotNull
    public IntStream ints(long streamSize, int randomNumberOrigin, int randomNumberBound) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException();
        }
        if (streamSize == 0L) {
            return IntStream.empty();
        }
        return this.ints(randomNumberOrigin, randomNumberBound).limit(streamSize);
    }

    @NotNull
    public LongStream longs(long streamSize, long randomNumberOrigin, long randomNumberBound) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException();
        }
        if (streamSize == 0L) {
            return LongStream.empty();
        }
        return this.longs(randomNumberOrigin, randomNumberBound).limit(streamSize);
    }

    @NotNull
    public DoubleStream doubles(long streamSize, double randomNumberOrigin, double randomNumberBound) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException();
        }
        if (streamSize == 0L) {
            return DoubleStream.empty();
        }
        return this.doubles(randomNumberOrigin, randomNumberBound).limit(streamSize);
    }

    @NotNull
    public IntStream ints(final int randomNumberOrigin, final int randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException();
        }
        return IntStream.generate(new IntSupplier(){
            private final int bound;
            {
                this.bound = randomNumberBound - randomNumberOrigin;
            }

            @Override
            public int getAsInt() {
                if (this.bound < 0) {
                    int result;
                    while (randomNumberOrigin >= (result = RandomCompat.this.random.nextInt()) || result >= randomNumberBound) {
                    }
                    return result;
                }
                return randomNumberOrigin + RandomCompat.this.random.nextInt(this.bound);
            }
        });
    }

    @NotNull
    public LongStream longs(final long randomNumberOrigin, final long randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException();
        }
        return LongStream.generate(new LongSupplier(){
            private final long bound;
            private final long boundMinus1;
            {
                this.bound = randomNumberBound - randomNumberOrigin;
                this.boundMinus1 = this.bound - 1L;
            }

            @Override
            public long getAsLong() {
                long result = RandomCompat.this.random.nextLong();
                if ((this.bound & this.boundMinus1) == 0L) {
                    result = (result & this.boundMinus1) + randomNumberOrigin;
                } else if (this.bound > 0L) {
                    long u = result >>> 1;
                    while (u + this.boundMinus1 - (result = u % this.bound) < 0L) {
                        u = RandomCompat.this.random.nextLong() >>> 1;
                    }
                    result += randomNumberOrigin;
                } else {
                    while (randomNumberOrigin >= result || result >= randomNumberBound) {
                        result = RandomCompat.this.random.nextLong();
                    }
                }
                return result;
            }
        });
    }

    @NotNull
    public DoubleStream doubles(final double randomNumberOrigin, final double randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException();
        }
        return DoubleStream.generate(new DoubleSupplier(){
            private final double bound;
            {
                this.bound = randomNumberBound - randomNumberOrigin;
            }

            @Override
            public double getAsDouble() {
                double result = RandomCompat.this.random.nextDouble() * this.bound + randomNumberOrigin;
                if (result >= randomNumberBound) {
                    result = Double.longBitsToDouble(Double.doubleToLongBits(randomNumberBound) - 1L);
                }
                return result;
            }
        });
    }
}

