/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.function.Supplier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Objects {
    private Objects() {
    }

    @Contract(pure=true)
    public static boolean equals(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && a.equals(b);
    }

    @Contract(pure=true)
    public static boolean deepEquals(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && b != null && Arrays.deepEquals(new Object[]{a}, new Object[]{b});
    }

    @Contract(pure=true)
    public static int hashCode(@Nullable Object o) {
        return o != null ? o.hashCode() : 0;
    }

    @Contract(pure=true)
    public static int hash(Object ... values) {
        if (values == null) {
            return 0;
        }
        int result = 1;
        for (Object element : values) {
            result = 31 * result + Objects.hashCode(element);
        }
        return result;
    }

    @NotNull
    @Contract(value="null, _ -> param2")
    public static String toString(@Nullable Object o, @NotNull String nullDefault) {
        return o != null ? o.toString() : nullDefault;
    }

    @Contract(pure=true)
    public static <T> int compare(@Nullable T a, @Nullable T b, @NotNull Comparator<? super T> c) {
        return a == b ? 0 : c.compare(a, b);
    }

    @Contract(pure=true)
    public static int compareInt(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    @Contract(pure=true)
    public static int compareLong(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    @NotNull
    @Contract(value="null -> fail; !null -> param1", pure=true)
    public static <T> T requireNonNull(@Nullable T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    @NotNull
    @Contract(value="null, _ -> fail; !null, _ -> param1", pure=true)
    public static <T> T requireNonNull(@Nullable T obj, @NotNull String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    @NotNull
    @Contract(value="null, _ -> fail; !null, _ -> param1")
    public static <T> T requireNonNull(@Nullable T obj, @NotNull Supplier<String> messageSupplier) {
        if (obj == null) {
            throw new NullPointerException(messageSupplier.get());
        }
        return obj;
    }

    @NotNull
    @Contract(value="!null, _ -> param1; null, !null -> param2; null, null -> fail", pure=true)
    public static <T> T requireNonNullElse(@Nullable T obj, @NotNull T defaultObj) {
        return obj != null ? obj : Objects.requireNonNull(defaultObj, "defaultObj");
    }

    @NotNull
    @Contract(value="!null, _ -> param1; null, null -> fail")
    public static <T> T requireNonNullElseGet(@Nullable T obj, @NotNull Supplier<? extends T> supplier) {
        if (obj != null) {
            return obj;
        }
        T suppliedObj = Objects.requireNonNull(supplier, "supplier").get();
        return Objects.requireNonNull(suppliedObj, "supplier.get()");
    }

    @NotNull
    @Contract(value="null -> fail; !null -> param1")
    public static <T> Collection<T> requireNonNullElements(@NotNull Collection<T> collection) {
        Objects.requireNonNull(collection);
        for (T t : collection) {
            Objects.requireNonNull(t);
        }
        return collection;
    }

    @Contract(value="null -> true; !null -> false", pure=true)
    public static boolean isNull(@Nullable Object obj) {
        return obj == null;
    }

    @Contract(value="null -> false; !null -> true", pure=true)
    public static boolean nonNull(@Nullable Object obj) {
        return obj != null;
    }
}

