/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.Collector;
import com.annimon.stream.Objects;
import com.annimon.stream.Stream;
import com.annimon.stream.function.BiConsumer;
import com.annimon.stream.function.BiFunction;
import com.annimon.stream.function.BinaryOperator;
import com.annimon.stream.function.Consumer;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.Predicate;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ToDoubleFunction;
import com.annimon.stream.function.ToIntFunction;
import com.annimon.stream.function.ToLongFunction;
import com.annimon.stream.function.UnaryOperator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Collectors {
    private static final Supplier<long[]> LONG_2ELEMENTS_ARRAY_SUPPLIER = new Supplier<long[]>(){

        @Override
        public long[] get() {
            return new long[]{0L, 0L};
        }
    };
    private static final Supplier<double[]> DOUBLE_2ELEMENTS_ARRAY_SUPPLIER = new Supplier<double[]>(){

        @Override
        public double[] get() {
            return new double[]{0.0, 0.0};
        }
    };

    private Collectors() {
    }

    @NotNull
    public static <T, R extends Collection<T>> Collector<T, ?, R> toCollection(@NotNull Supplier<R> collectionSupplier) {
        return new CollectorsImpl(collectionSupplier, new BiConsumer<R, T>(){

            @Override
            public void accept(@NotNull R t, T u) {
                t.add(u);
            }
        });
    }

    @NotNull
    public static <T> Collector<T, ?, List<T>> toList() {
        return new CollectorsImpl(new Supplier<List<T>>(){

            @Override
            @NotNull
            public List<T> get() {
                return new ArrayList();
            }
        }, new BiConsumer<List<T>, T>(){

            @Override
            public void accept(@NotNull List<T> t, T u) {
                t.add(u);
            }
        });
    }

    @NotNull
    public static <T> Collector<T, ?, List<T>> toUnmodifiableList() {
        return Collectors.collectingAndThen(Collectors.<T>toList(), new UnaryOperator<List<T>>(){

            @Override
            @NotNull
            public List<T> apply(@NotNull List<T> list) {
                Objects.requireNonNullElements(list);
                return Collections.unmodifiableList(list);
            }
        });
    }

    @NotNull
    public static <T> Collector<T, ?, Set<T>> toSet() {
        return new CollectorsImpl(new Supplier<Set<T>>(){

            @Override
            @NotNull
            public Set<T> get() {
                return new HashSet();
            }
        }, new BiConsumer<Set<T>, T>(){

            @Override
            public void accept(@NotNull Set<T> set, T t) {
                set.add(t);
            }
        });
    }

    @NotNull
    public static <T> Collector<T, ?, Set<T>> toUnmodifiableSet() {
        return Collectors.collectingAndThen(Collectors.<T>toSet(), new UnaryOperator<Set<T>>(){

            @Override
            @NotNull
            public Set<T> apply(@NotNull Set<T> set) {
                Objects.requireNonNullElements(set);
                return Collections.unmodifiableSet(set);
            }
        });
    }

    @NotNull
    public static <T, K> Collector<T, ?, Map<K, T>> toMap(@NotNull Function<? super T, ? extends K> keyMapper) {
        return Collectors.toMap(keyMapper, UnaryOperator.Util.identity());
    }

    @NotNull
    public static <T, K, V> Collector<T, ?, Map<K, V>> toMap(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull Function<? super T, ? extends V> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, Collectors.<K, V>hashMapSupplier());
    }

    @NotNull
    public static <T, K, V, M extends Map<K, V>> Collector<T, ?, M> toMap(final @NotNull Function<? super T, ? extends K> keyMapper, final @NotNull Function<? super T, ? extends V> valueMapper, @NotNull Supplier<M> mapFactory) {
        return new CollectorsImpl(mapFactory, new BiConsumer<M, T>(){

            @Override
            public void accept(M map, T t) {
                Object value;
                Object key = keyMapper.apply(t);
                Object oldValue = map.put(key, value = Objects.requireNonNull(valueMapper.apply(t)));
                if (oldValue != null) {
                    map.put(key, oldValue);
                    throw Collectors.duplicateKeyException(key, oldValue, value);
                }
            }
        });
    }

    @NotNull
    public static <T, K, V> Collector<T, ?, Map<K, V>> toUnmodifiableMap(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull Function<? super T, ? extends V> valueMapper) {
        return Collectors.collectingAndThen(Collectors.toMap(keyMapper, valueMapper), Collectors.<K, V>toUnmodifiableMapConverter());
    }

    @NotNull
    public static <T, K, V> Collector<T, ?, Map<K, V>> toMap(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull Function<? super T, ? extends V> valueMapper, @NotNull BinaryOperator<V> mergeFunction) {
        return Collectors.toMap(keyMapper, valueMapper, mergeFunction, Collectors.<K, V>hashMapSupplier());
    }

    @NotNull
    public static <T, K, V, M extends Map<K, V>> Collector<T, ?, M> toMap(final @NotNull Function<? super T, ? extends K> keyMapper, final @NotNull Function<? super T, ? extends V> valueMapper, final @NotNull BinaryOperator<V> mergeFunction, @NotNull Supplier<M> mapFactory) {
        return new CollectorsImpl(mapFactory, new BiConsumer<M, T>(){

            @Override
            public void accept(@NotNull M map, T t) {
                Object key = keyMapper.apply(t);
                Object value = valueMapper.apply(t);
                Collectors.mapMerge(map, key, value, mergeFunction);
            }
        });
    }

    @NotNull
    public static <T, K, V> Collector<T, ?, Map<K, V>> toUnmodifiableMap(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull Function<? super T, ? extends V> valueMapper, @NotNull BinaryOperator<V> mergeFunction) {
        return Collectors.collectingAndThen(Collectors.toMap(keyMapper, valueMapper, mergeFunction, Collectors.<K, V>hashMapSupplier()), Collectors.<K, V>toUnmodifiableMapConverter());
    }

    @NotNull
    public static Collector<CharSequence, ?, String> joining() {
        return Collectors.joining("");
    }

    @NotNull
    public static Collector<CharSequence, ?, String> joining(@NotNull CharSequence delimiter) {
        return Collectors.joining(delimiter, "", "");
    }

    @NotNull
    public static Collector<CharSequence, ?, String> joining(@NotNull CharSequence delimiter, @NotNull CharSequence prefix, @NotNull CharSequence suffix) {
        return Collectors.joining(delimiter, prefix, suffix, prefix.toString() + suffix.toString());
    }

    @NotNull
    public static Collector<CharSequence, ?, String> joining(final @NotNull CharSequence delimiter, final @NotNull CharSequence prefix, final @NotNull CharSequence suffix, final @NotNull String emptyValue) {
        return new CollectorsImpl<CharSequence, StringBuilder, String>(new Supplier<StringBuilder>(){

            @Override
            @NotNull
            public StringBuilder get() {
                return new StringBuilder();
            }
        }, new BiConsumer<StringBuilder, CharSequence>(){

            @Override
            public void accept(@NotNull StringBuilder t, CharSequence u) {
                if (t.length() > 0) {
                    t.append(delimiter);
                } else {
                    t.append(prefix);
                }
                t.append(u);
            }
        }, new Function<StringBuilder, String>(){

            @Override
            @NotNull
            public String apply(@NotNull StringBuilder value) {
                if (value.length() == 0) {
                    return emptyValue;
                }
                value.append(suffix);
                return value.toString();
            }
        });
    }

    @Deprecated
    @NotNull
    public static <T> Collector<T, ?, Double> averaging(final @NotNull Function<? super T, Double> mapper) {
        return Collectors.averagingDouble(new ToDoubleFunction<T>(){

            @Override
            public double applyAsDouble(T t) {
                return (Double)mapper.apply(t);
            }
        });
    }

    @NotNull
    public static <T> Collector<T, ?, Double> averagingInt(final @NotNull ToIntFunction<? super T> mapper) {
        return Collectors.averagingHelper(new BiConsumer<long[], T>(){

            @Override
            public void accept(long[] t, T u) {
                t[0] = t[0] + 1L;
                t[1] = t[1] + (long)mapper.applyAsInt(u);
            }
        });
    }

    @NotNull
    public static <T> Collector<T, ?, Double> averagingLong(final @NotNull ToLongFunction<? super T> mapper) {
        return Collectors.averagingHelper(new BiConsumer<long[], T>(){

            @Override
            public void accept(long[] t, T u) {
                t[0] = t[0] + 1L;
                t[1] = t[1] + mapper.applyAsLong(u);
            }
        });
    }

    @NotNull
    private static <T> Collector<T, ?, Double> averagingHelper(@NotNull BiConsumer<long[], T> accumulator) {
        return new CollectorsImpl<T, long[], Double>(LONG_2ELEMENTS_ARRAY_SUPPLIER, accumulator, new Function<long[], Double>(){

            @Override
            @NotNull
            public Double apply(long[] t) {
                if (t[0] == 0L) {
                    return 0.0;
                }
                return (double)t[1] / (double)t[0];
            }
        });
    }

    @NotNull
    public static <T> Collector<T, ?, Double> averagingDouble(final @NotNull ToDoubleFunction<? super T> mapper) {
        return new CollectorsImpl(DOUBLE_2ELEMENTS_ARRAY_SUPPLIER, new BiConsumer<double[], T>(){

            @Override
            public void accept(double[] t, T u) {
                t[0] = t[0] + 1.0;
                t[1] = t[1] + mapper.applyAsDouble(u);
            }
        }, new Function<double[], Double>(){

            @Override
            @NotNull
            public Double apply(double[] t) {
                if (t[0] == 0.0) {
                    return 0.0;
                }
                return t[1] / t[0];
            }
        });
    }

    @NotNull
    public static <T> Collector<T, ?, Integer> summingInt(final @NotNull ToIntFunction<? super T> mapper) {
        return new CollectorsImpl(new Supplier<int[]>(){

            @Override
            @NotNull
            public int[] get() {
                return new int[]{0};
            }
        }, new BiConsumer<int[], T>(){

            @Override
            public void accept(int[] t, T u) {
                t[0] = t[0] + mapper.applyAsInt(u);
            }
        }, new Function<int[], Integer>(){

            @Override
            public Integer apply(int[] value) {
                return value[0];
            }
        });
    }

    @NotNull
    public static <T> Collector<T, ?, Long> summingLong(final @NotNull ToLongFunction<? super T> mapper) {
        return new CollectorsImpl(LONG_2ELEMENTS_ARRAY_SUPPLIER, new BiConsumer<long[], T>(){

            @Override
            public void accept(long[] t, T u) {
                t[0] = t[0] + mapper.applyAsLong(u);
            }
        }, new Function<long[], Long>(){

            @Override
            public Long apply(long[] value) {
                return value[0];
            }
        });
    }

    @NotNull
    public static <T> Collector<T, ?, Double> summingDouble(final @NotNull ToDoubleFunction<? super T> mapper) {
        return new CollectorsImpl(DOUBLE_2ELEMENTS_ARRAY_SUPPLIER, new BiConsumer<double[], T>(){

            @Override
            public void accept(double[] t, T u) {
                t[0] = t[0] + mapper.applyAsDouble(u);
            }
        }, new Function<double[], Double>(){

            @Override
            public Double apply(double[] value) {
                return value[0];
            }
        });
    }

    @NotNull
    public static <T> Collector<T, ?, Long> counting() {
        return Collectors.summingLong(new ToLongFunction<T>(){

            @Override
            public long applyAsLong(T t) {
                return 1L;
            }
        });
    }

    @NotNull
    public static <T> Collector<T, ?, T> reducing(final @Nullable T identity, final @NotNull BinaryOperator<T> op) {
        return new CollectorsImpl(new Supplier<Tuple1<T>>(){

            @Override
            @NotNull
            public Tuple1<T> get() {
                return new Tuple1<Object>(identity);
            }
        }, new BiConsumer<Tuple1<T>, T>(){

            @Override
            public void accept(@NotNull Tuple1<T> tuple, T value) {
                tuple.a = op.apply(tuple.a, value);
            }
        }, new Function<Tuple1<T>, T>(){

            @Override
            public T apply(@NotNull Tuple1<T> tuple) {
                return tuple.a;
            }
        });
    }

    @NotNull
    public static <T, R> Collector<T, ?, R> reducing(final @Nullable R identity, final @NotNull Function<? super T, ? extends R> mapper, final @NotNull BinaryOperator<R> op) {
        return new CollectorsImpl(new Supplier<Tuple1<R>>(){

            @Override
            @NotNull
            public Tuple1<R> get() {
                return new Tuple1<Object>(identity);
            }
        }, new BiConsumer<Tuple1<R>, T>(){

            @Override
            public void accept(@NotNull Tuple1<R> tuple, T value) {
                tuple.a = op.apply(tuple.a, mapper.apply(value));
            }
        }, new Function<Tuple1<R>, R>(){

            @Override
            public R apply(@NotNull Tuple1<R> tuple) {
                return tuple.a;
            }
        });
    }

    @NotNull
    public static <T, A, R> Collector<T, ?, R> filtering(final @NotNull Predicate<? super T> predicate, @NotNull Collector<? super T, A, R> downstream) {
        final BiConsumer<A, ? super T> accumulator = downstream.accumulator();
        return new CollectorsImpl(downstream.supplier(), new BiConsumer<A, T>(){

            @Override
            public void accept(A a, T t) {
                if (predicate.test(t)) {
                    accumulator.accept(a, t);
                }
            }
        }, downstream.finisher());
    }

    @NotNull
    public static <T, U, A, R> Collector<T, ?, R> mapping(final @NotNull Function<? super T, ? extends U> mapper, @NotNull Collector<? super U, A, R> downstream) {
        final BiConsumer<A, ? super U> accumulator = downstream.accumulator();
        return new CollectorsImpl(downstream.supplier(), new BiConsumer<A, T>(){

            @Override
            public void accept(A a, T t) {
                accumulator.accept(a, mapper.apply(t));
            }
        }, downstream.finisher());
    }

    @NotNull
    public static <T, U, A, R> Collector<T, ?, R> flatMapping(final @NotNull Function<? super T, ? extends Stream<? extends U>> mapper, @NotNull Collector<? super U, A, R> downstream) {
        final BiConsumer<A, ? super U> accumulator = downstream.accumulator();
        return new CollectorsImpl(downstream.supplier(), new BiConsumer<A, T>(){

            @Override
            public void accept(final A a, T t) {
                Stream stream = (Stream)mapper.apply(t);
                if (stream == null) {
                    return;
                }
                stream.forEach(new Consumer<U>(){

                    @Override
                    public void accept(U u) {
                        accumulator.accept(a, u);
                    }
                });
            }
        }, downstream.finisher());
    }

    @NotNull
    public static <T, A, IR, OR> Collector<T, A, OR> collectingAndThen(@NotNull Collector<T, A, IR> c, @NotNull Function<IR, OR> finisher) {
        Objects.requireNonNull(c);
        Objects.requireNonNull(finisher);
        return new CollectorsImpl<T, A, OR>(c.supplier(), c.accumulator(), Function.Util.andThen(c.finisher(), finisher));
    }

    @NotNull
    public static <T, K> Collector<T, ?, Map<K, List<T>>> groupingBy(@NotNull Function<? super T, ? extends K> classifier) {
        return Collectors.groupingBy(classifier, Collectors.<T>toList());
    }

    @NotNull
    public static <T, K, A, D> Collector<T, ?, Map<K, D>> groupingBy(@NotNull Function<? super T, ? extends K> classifier, @NotNull Collector<? super T, A, D> downstream) {
        return Collectors.groupingBy(classifier, Collectors.hashMapSupplier(), downstream);
    }

    @NotNull
    public static <T, K, D, A, M extends Map<K, D>> Collector<T, ?, M> groupingBy(final @NotNull Function<? super T, ? extends K> classifier, @NotNull Supplier<M> mapFactory, final @NotNull Collector<? super T, A, D> downstream) {
        final Function<A, D> downstreamFinisher = downstream.finisher();
        Function finisher = new Function<Map<K, A>, M>(){

            @Override
            @NotNull
            public M apply(@NotNull Map<K, A> map) {
                for (Map.Entry entry : map.entrySet()) {
                    Object value = entry.getValue();
                    value = downstreamFinisher.apply(value);
                    entry.setValue(value);
                }
                Map castedMap = map;
                return castedMap;
            }
        };
        Supplier<M> castedMapFactory = mapFactory;
        return new CollectorsImpl(castedMapFactory, new BiConsumer<Map<K, A>, T>(){

            @Override
            public void accept(@NotNull Map<K, A> map, T t) {
                Object key = Objects.requireNonNull(classifier.apply(t), "element cannot be mapped to a null key");
                Object container = map.get(key);
                if (container == null) {
                    container = downstream.supplier().get();
                    map.put(key, container);
                }
                downstream.accumulator().accept(container, t);
            }
        }, finisher);
    }

    @NotNull
    public static <T> Collector<T, ?, Map<Boolean, List<T>>> partitioningBy(@NotNull Predicate<? super T> predicate) {
        return Collectors.partitioningBy(predicate, Collectors.<T>toList());
    }

    @NotNull
    public static <T, D, A> Collector<T, ?, Map<Boolean, D>> partitioningBy(final @NotNull Predicate<? super T> predicate, final @NotNull Collector<? super T, A, D> downstream) {
        final BiConsumer<A, ? super T> downstreamAccumulator = downstream.accumulator();
        return new CollectorsImpl(new Supplier<Tuple2<A>>(){

            @Override
            @NotNull
            public Tuple2<A> get() {
                return new Tuple2(downstream.supplier().get(), downstream.supplier().get());
            }
        }, new BiConsumer<Tuple2<A>, T>(){

            @Override
            public void accept(@NotNull Tuple2<A> container, T t) {
                downstreamAccumulator.accept(predicate.test(t) ? container.a : container.b, t);
            }
        }, new Function<Tuple2<A>, Map<Boolean, D>>(){

            @Override
            @NotNull
            public Map<Boolean, D> apply(@NotNull Tuple2<A> container) {
                Function finisher = downstream.finisher();
                HashMap result = new HashMap(2);
                result.put(Boolean.TRUE, finisher.apply(container.a));
                result.put(Boolean.FALSE, finisher.apply(container.b));
                return result;
            }
        });
    }

    @NotNull
    public static <T, R1, R2, R> Collector<T, ?, R> teeing(@NotNull Collector<? super T, ?, R1> downstream1, @NotNull Collector<? super T, ?, R2> downstream2, @NotNull BiFunction<? super R1, ? super R2, R> merger) {
        return Collectors.teeingImpl(downstream1, downstream2, merger);
    }

    private static <T, A1, A2, R1, R2, R> Collector<T, ?, R> teeingImpl(@NotNull Collector<? super T, A1, R1> downstream1, @NotNull Collector<? super T, A2, R2> downstream2, final @NotNull BiFunction<? super R1, ? super R2, R> merger) {
        Objects.requireNonNull(downstream1, "downstream1");
        Objects.requireNonNull(downstream2, "downstream2");
        Objects.requireNonNull(merger, "merger");
        final Supplier<A1> supplier1 = Objects.requireNonNull(downstream1.supplier(), "downstream1 supplier");
        final Supplier<A2> supplier2 = Objects.requireNonNull(downstream2.supplier(), "downstream2 supplier");
        final BiConsumer<A1, ? super T> acc1 = Objects.requireNonNull(downstream1.accumulator(), "downstream1 accumulator");
        final BiConsumer<A2, ? super T> acc2 = Objects.requireNonNull(downstream2.accumulator(), "downstream2 accumulator");
        final Function<A1, R1> finisher1 = Objects.requireNonNull(downstream1.finisher(), "downstream1 finisher");
        final Function<A2, R2> finisher2 = Objects.requireNonNull(downstream2.finisher(), "downstream2 finisher");
        return new CollectorsImpl(new Supplier<Map.Entry<A1, A2>>(){

            @Override
            @NotNull
            public Map.Entry<A1, A2> get() {
                return new AbstractMap.SimpleEntry(supplier1.get(), supplier2.get());
            }
        }, new BiConsumer<Map.Entry<A1, A2>, T>(){

            @Override
            public void accept(@NotNull Map.Entry<A1, A2> entry, T t) {
                acc1.accept(entry.getKey(), t);
                acc2.accept(entry.getValue(), t);
            }
        }, new Function<Map.Entry<A1, A2>, R>(){

            @Override
            @NotNull
            public R apply(@NotNull Map.Entry<A1, A2> entry) {
                return merger.apply(finisher1.apply(entry.getKey()), finisher2.apply(entry.getValue()));
            }
        });
    }

    @NotNull
    private static <K, V> Supplier<Map<K, V>> hashMapSupplier() {
        return new Supplier<Map<K, V>>(){

            @Override
            @NotNull
            public Map<K, V> get() {
                return new HashMap();
            }
        };
    }

    @NotNull
    private static IllegalStateException duplicateKeyException(Object key, Object old, Object value) {
        return new IllegalStateException(String.format("Duplicate key %s (attempted merging values %s and %s)", key, old, value));
    }

    private static <K, V> void mapMerge(@NotNull Map<K, V> map, K key, V value, @NotNull BinaryOperator<V> merger) {
        V oldValue = map.get(key);
        Object newValue = oldValue == null ? value : merger.apply(oldValue, value);
        if (newValue == null) {
            map.remove(key);
        } else {
            map.put(key, newValue);
        }
    }

    @NotNull
    private static <K, V> UnaryOperator<Map<K, V>> toUnmodifiableMapConverter() {
        return new UnaryOperator<Map<K, V>>(){

            @Override
            @NotNull
            public Map<K, V> apply(@NotNull Map<K, V> map) {
                Objects.requireNonNullElements(map.keySet());
                Objects.requireNonNullElements(map.values());
                return Collections.unmodifiableMap(map);
            }
        };
    }

    @NotNull
    static <A, R> Function<A, R> castIdentity() {
        return new Function<A, R>(){

            @Override
            @NotNull
            public R apply(@NotNull A value) {
                return value;
            }
        };
    }

    private static final class CollectorsImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final Function<A, R> finisher;

        public CollectorsImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator) {
            this(supplier, accumulator, Collectors.castIdentity());
        }

        public CollectorsImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, Function<A, R> finisher) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.finisher = finisher;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        @Nullable
        public Function<A, R> finisher() {
            return this.finisher;
        }
    }

    private static final class Tuple2<A> {
        final A a;
        final A b;

        Tuple2(A a, A b) {
            this.a = a;
            this.b = b;
        }
    }

    private static final class Tuple1<A> {
        A a;

        Tuple1(A a) {
            this.a = a;
        }
    }
}

