/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.Objects;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.ToDoubleFunction;
import com.annimon.stream.function.ToIntFunction;
import com.annimon.stream.function.ToLongFunction;
import java.util.Collections;
import java.util.Comparator;

public final class ComparatorCompat<T>
implements Comparator<T> {
    private static final ComparatorCompat<Comparable<Object>> NATURAL_ORDER = new ComparatorCompat<Comparable<Object>>(new Comparator<Comparable<Object>>(){

        @Override
        public int compare(Comparable<Object> o1, Comparable<Object> o2) {
            return o1.compareTo(o2);
        }
    });
    private static final ComparatorCompat<Comparable<Object>> REVERSE_ORDER = new ComparatorCompat(Collections.reverseOrder());
    private final Comparator<? super T> comparator;

    public static <T extends Comparable<? super T>> ComparatorCompat<T> naturalOrder() {
        return NATURAL_ORDER;
    }

    public static <T extends Comparable<? super T>> ComparatorCompat<T> reverseOrder() {
        return REVERSE_ORDER;
    }

    public static <T> Comparator<T> reversed(Comparator<T> comparator) {
        return Collections.reverseOrder(comparator);
    }

    public static <T> Comparator<T> thenComparing(final Comparator<? super T> c1, final Comparator<? super T> c2) {
        Objects.requireNonNull(c1);
        Objects.requireNonNull(c2);
        return new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                int result = c1.compare(t1, t2);
                return result != 0 ? result : c2.compare(t1, t2);
            }
        };
    }

    public static <T, U> ComparatorCompat<T> comparing(final Function<? super T, ? extends U> keyExtractor, final Comparator<? super U> keyComparator) {
        Objects.requireNonNull(keyExtractor);
        Objects.requireNonNull(keyComparator);
        return new ComparatorCompat<T>(new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                Object u1 = keyExtractor.apply(t1);
                Object u2 = keyExtractor.apply(t2);
                return keyComparator.compare(u1, u2);
            }
        });
    }

    public static <T, U extends Comparable<? super U>> ComparatorCompat<T> comparing(final Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return new ComparatorCompat<T>(new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                Comparable u1 = (Comparable)keyExtractor.apply(t1);
                Comparable u2 = (Comparable)keyExtractor.apply(t2);
                return u1.compareTo(u2);
            }
        });
    }

    public static <T> ComparatorCompat<T> comparingInt(final ToIntFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return new ComparatorCompat<T>(new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                int i1 = keyExtractor.applyAsInt(t1);
                int i2 = keyExtractor.applyAsInt(t2);
                return Objects.compareInt(i1, i2);
            }
        });
    }

    public static <T> ComparatorCompat<T> comparingLong(final ToLongFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return new ComparatorCompat<T>(new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                long l1 = keyExtractor.applyAsLong(t1);
                long l2 = keyExtractor.applyAsLong(t2);
                return Objects.compareLong(l1, l2);
            }
        });
    }

    public static <T> ComparatorCompat<T> comparingDouble(final ToDoubleFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return new ComparatorCompat<T>(new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                double d1 = keyExtractor.applyAsDouble(t1);
                double d2 = keyExtractor.applyAsDouble(t2);
                return Double.compare(d1, d2);
            }
        });
    }

    public static <T> ComparatorCompat<T> nullsFirst() {
        return ComparatorCompat.nullsComparator(true, null);
    }

    public static <T> ComparatorCompat<T> nullsFirst(Comparator<? super T> comparator) {
        return ComparatorCompat.nullsComparator(true, comparator);
    }

    public static <T> ComparatorCompat<T> nullsLast() {
        return ComparatorCompat.nullsComparator(false, null);
    }

    public static <T> ComparatorCompat<T> nullsLast(Comparator<? super T> comparator) {
        return ComparatorCompat.nullsComparator(false, comparator);
    }

    private static <T> ComparatorCompat<T> nullsComparator(final boolean nullFirst, final Comparator<? super T> comparator) {
        return new ComparatorCompat<T>(new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                if (t1 == null) {
                    return t2 == null ? 0 : (nullFirst ? -1 : 1);
                }
                if (t2 == null) {
                    return nullFirst ? 1 : -1;
                }
                return comparator == null ? 0 : comparator.compare(t1, t2);
            }
        });
    }

    public static <T> ComparatorCompat<T> chain(Comparator<T> comparator) {
        return new ComparatorCompat<T>(comparator);
    }

    public ComparatorCompat(Comparator<? super T> comparator) {
        this.comparator = comparator;
    }

    @Override
    public ComparatorCompat<T> reversed() {
        return new ComparatorCompat<T>(Collections.reverseOrder(this.comparator));
    }

    @Override
    public ComparatorCompat<T> thenComparing(final Comparator<? super T> other) {
        Objects.requireNonNull(other);
        return new ComparatorCompat<T>(new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                int result = ComparatorCompat.this.comparator.compare(t1, t2);
                return result != 0 ? result : other.compare(t1, t2);
            }
        });
    }

    @Override
    public <U> ComparatorCompat<T> thenComparing(Function<? super T, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
        return this.thenComparing(ComparatorCompat.comparing(keyExtractor, keyComparator));
    }

    @Override
    public <U extends Comparable<? super U>> ComparatorCompat<T> thenComparing(Function<? super T, ? extends U> keyExtractor) {
        return this.thenComparing(ComparatorCompat.comparing(keyExtractor));
    }

    @Override
    public ComparatorCompat<T> thenComparingInt(ToIntFunction<? super T> keyExtractor) {
        return this.thenComparing(ComparatorCompat.comparingInt(keyExtractor));
    }

    @Override
    public ComparatorCompat<T> thenComparingLong(ToLongFunction<? super T> keyExtractor) {
        return this.thenComparing(ComparatorCompat.comparingLong(keyExtractor));
    }

    @Override
    public ComparatorCompat<T> thenComparingDouble(ToDoubleFunction<? super T> keyExtractor) {
        return this.thenComparing(ComparatorCompat.comparingDouble(keyExtractor));
    }

    public Comparator<T> comparator() {
        return this.comparator;
    }

    @Override
    public int compare(T o1, T o2) {
        return this.comparator.compare(o1, o2);
    }
}

