/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.internal;

import com.annimon.stream.function.DoubleConsumer;
import com.annimon.stream.function.IntConsumer;
import com.annimon.stream.function.LongConsumer;
import com.annimon.stream.internal.Compat;
import com.annimon.stream.iterator.PrimitiveIterator;
import java.util.Arrays;
import java.util.Iterator;

final class SpinedBuffer {
    static final int MIN_CHUNK_POWER = 4;
    static final int MIN_CHUNK_SIZE = 16;
    private static final int MAX_CHUNK_POWER = 30;
    static final int MIN_SPINE_SIZE = 8;

    private SpinedBuffer() {
    }

    static class OfDouble
    extends OfPrimitive<Double, double[], DoubleConsumer>
    implements DoubleConsumer {
        OfDouble() {
        }

        OfDouble(int initialCapacity) {
            super(initialCapacity);
        }

        protected double[][] newArrayArray(int size) {
            return new double[size][];
        }

        @Override
        public double[] newArray(int size) {
            return new double[size];
        }

        @Override
        protected int arrayLength(double[] array) {
            return array.length;
        }

        @Override
        public void accept(double i) {
            this.preAccept();
            ((double[])this.curChunk)[this.elementIndex++] = i;
        }

        public double get(long index) {
            int ch = this.chunkFor(index);
            if (this.spineIndex == 0 && ch == 0) {
                return ((double[])this.curChunk)[(int)index];
            }
            return ((double[][])this.spine)[ch][(int)(index - this.priorElementCount[ch])];
        }

        public PrimitiveIterator.OfDouble iterator() {
            return new PrimitiveIterator.OfDouble(){
                long index = 0L;

                @Override
                public double nextDouble() {
                    return OfDouble.this.get(this.index++);
                }

                @Override
                public boolean hasNext() {
                    return this.index < OfDouble.this.count();
                }
            };
        }
    }

    static class OfLong
    extends OfPrimitive<Long, long[], LongConsumer>
    implements LongConsumer {
        OfLong() {
        }

        OfLong(int initialCapacity) {
            super(initialCapacity);
        }

        protected long[][] newArrayArray(int size) {
            return new long[size][];
        }

        @Override
        public long[] newArray(int size) {
            return new long[size];
        }

        @Override
        protected int arrayLength(long[] array) {
            return array.length;
        }

        @Override
        public void accept(long i) {
            this.preAccept();
            ((long[])this.curChunk)[this.elementIndex++] = i;
        }

        public long get(long index) {
            int ch = this.chunkFor(index);
            if (this.spineIndex == 0 && ch == 0) {
                return ((long[])this.curChunk)[(int)index];
            }
            return ((long[][])this.spine)[ch][(int)(index - this.priorElementCount[ch])];
        }

        public PrimitiveIterator.OfLong iterator() {
            return new PrimitiveIterator.OfLong(){
                long index = 0L;

                @Override
                public long nextLong() {
                    return OfLong.this.get(this.index++);
                }

                @Override
                public boolean hasNext() {
                    return this.index < OfLong.this.count();
                }
            };
        }
    }

    static class OfInt
    extends OfPrimitive<Integer, int[], IntConsumer>
    implements IntConsumer {
        OfInt() {
        }

        OfInt(int initialCapacity) {
            super(initialCapacity);
        }

        protected int[][] newArrayArray(int size) {
            return new int[size][];
        }

        @Override
        public int[] newArray(int size) {
            return new int[size];
        }

        @Override
        protected int arrayLength(int[] array) {
            return array.length;
        }

        @Override
        public void accept(int i) {
            this.preAccept();
            ((int[])this.curChunk)[this.elementIndex++] = i;
        }

        public int get(long index) {
            int ch = this.chunkFor(index);
            if (this.spineIndex == 0 && ch == 0) {
                return ((int[])this.curChunk)[(int)index];
            }
            return ((int[][])this.spine)[ch][(int)(index - this.priorElementCount[ch])];
        }

        public PrimitiveIterator.OfInt iterator() {
            return new PrimitiveIterator.OfInt(){
                long index = 0L;

                @Override
                public int nextInt() {
                    return OfInt.this.get(this.index++);
                }

                @Override
                public boolean hasNext() {
                    return this.index < OfInt.this.count();
                }
            };
        }
    }

    static abstract class OfPrimitive<E, T_ARR, T_CONS>
    implements Iterable<E> {
        final int initialChunkPower;
        int elementIndex;
        int spineIndex;
        long[] priorElementCount;
        T_ARR curChunk;
        T_ARR[] spine;

        OfPrimitive(int initialCapacity) {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
            }
            this.initialChunkPower = Math.max(4, 32 - Integer.numberOfLeadingZeros(initialCapacity - 1));
            this.curChunk = this.newArray(1 << this.initialChunkPower);
        }

        OfPrimitive() {
            this.initialChunkPower = 4;
            this.curChunk = this.newArray(1 << this.initialChunkPower);
        }

        @Override
        public abstract Iterator<E> iterator();

        protected abstract T_ARR[] newArrayArray(int var1);

        protected abstract T_ARR newArray(int var1);

        protected abstract int arrayLength(T_ARR var1);

        public boolean isEmpty() {
            return this.spineIndex == 0 && this.elementIndex == 0;
        }

        public long count() {
            return this.spineIndex == 0 ? (long)this.elementIndex : this.priorElementCount[this.spineIndex] + (long)this.elementIndex;
        }

        int chunkSize(int n) {
            int power = n == 0 || n == 1 ? this.initialChunkPower : Math.min(this.initialChunkPower + n - 1, 30);
            return 1 << power;
        }

        long capacity() {
            return this.spineIndex == 0 ? (long)this.arrayLength(this.curChunk) : this.priorElementCount[this.spineIndex] + (long)this.arrayLength(this.spine[this.spineIndex]);
        }

        private void inflateSpine() {
            if (this.spine == null) {
                this.spine = this.newArrayArray(8);
                this.priorElementCount = new long[8];
                this.spine[0] = this.curChunk;
            }
        }

        final void ensureCapacity(long targetSize) {
            long capacity = this.capacity();
            if (targetSize > capacity) {
                this.inflateSpine();
                int i = this.spineIndex + 1;
                while (targetSize > capacity) {
                    if (i >= this.spine.length) {
                        int newSpineSize = this.spine.length * 2;
                        this.spine = Arrays.copyOf(this.spine, newSpineSize);
                        this.priorElementCount = Arrays.copyOf(this.priorElementCount, newSpineSize);
                    }
                    int nextChunkSize = this.chunkSize(i);
                    this.spine[i] = this.newArray(nextChunkSize);
                    this.priorElementCount[i] = this.priorElementCount[i - 1] + (long)this.arrayLength(this.spine[i - 1]);
                    capacity += (long)nextChunkSize;
                    ++i;
                }
            }
        }

        void increaseCapacity() {
            this.ensureCapacity(this.capacity() + 1L);
        }

        int chunkFor(long index) {
            if (this.spineIndex == 0) {
                if (index < (long)this.elementIndex) {
                    return 0;
                }
                throw new IndexOutOfBoundsException(Long.toString(index));
            }
            if (index >= this.count()) {
                throw new IndexOutOfBoundsException(Long.toString(index));
            }
            for (int j = 0; j <= this.spineIndex; ++j) {
                if (index >= this.priorElementCount[j] + (long)this.arrayLength(this.spine[j])) continue;
                return j;
            }
            throw new IndexOutOfBoundsException(Long.toString(index));
        }

        void copyInto(T_ARR array, int offset) {
            long finalOffset = (long)offset + this.count();
            if (finalOffset > (long)this.arrayLength(array) || finalOffset < (long)offset) {
                throw new IndexOutOfBoundsException("does not fit");
            }
            if (this.spineIndex == 0) {
                System.arraycopy(this.curChunk, 0, array, offset, this.elementIndex);
            } else {
                for (int i = 0; i < this.spineIndex; ++i) {
                    System.arraycopy(this.spine[i], 0, array, offset, this.arrayLength(this.spine[i]));
                    offset += this.arrayLength(this.spine[i]);
                }
                if (this.elementIndex > 0) {
                    System.arraycopy(this.curChunk, 0, array, offset, this.elementIndex);
                }
            }
        }

        public T_ARR asPrimitiveArray() {
            long size = this.count();
            Compat.checkMaxArraySize(size);
            T_ARR result = this.newArray((int)size);
            this.copyInto(result, 0);
            return result;
        }

        void preAccept() {
            if (this.elementIndex == this.arrayLength(this.curChunk)) {
                this.inflateSpine();
                if (this.spineIndex + 1 >= this.spine.length || this.spine[this.spineIndex + 1] == null) {
                    this.increaseCapacity();
                }
                this.elementIndex = 0;
                ++this.spineIndex;
                this.curChunk = this.spine[this.spineIndex];
            }
        }

        public void clear() {
            if (this.spine != null) {
                this.curChunk = this.spine[0];
                this.spine = null;
                this.priorElementCount = null;
            }
            this.elementIndex = 0;
            this.spineIndex = 0;
        }
    }
}

