/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.LongStream;
import com.annimon.stream.Objects;
import com.annimon.stream.Optional;
import com.annimon.stream.OptionalInt;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.LongConsumer;
import com.annimon.stream.function.LongFunction;
import com.annimon.stream.function.LongPredicate;
import com.annimon.stream.function.LongSupplier;
import com.annimon.stream.function.LongToIntFunction;
import com.annimon.stream.function.LongUnaryOperator;
import com.annimon.stream.function.Supplier;
import java.util.NoSuchElementException;

public final class OptionalLong {
    private static final OptionalLong EMPTY = new OptionalLong();
    private final boolean isPresent;
    private final long value;

    public static OptionalLong empty() {
        return EMPTY;
    }

    public static OptionalLong of(long value) {
        return new OptionalLong(value);
    }

    private OptionalLong() {
        this.isPresent = false;
        this.value = 0L;
    }

    private OptionalLong(long value) {
        this.isPresent = true;
        this.value = value;
    }

    public long getAsLong() {
        return this.orElseThrow();
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void ifPresent(LongConsumer consumer) {
        if (this.isPresent) {
            consumer.accept(this.value);
        }
    }

    public void ifPresentOrElse(LongConsumer consumer, Runnable emptyAction) {
        if (this.isPresent) {
            consumer.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public OptionalLong executeIfPresent(LongConsumer consumer) {
        this.ifPresent(consumer);
        return this;
    }

    public OptionalLong executeIfAbsent(Runnable action) {
        if (!this.isPresent()) {
            action.run();
        }
        return this;
    }

    public <R> R custom(Function<OptionalLong, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    public OptionalLong filter(LongPredicate predicate) {
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : OptionalLong.empty();
    }

    public OptionalLong filterNot(LongPredicate predicate) {
        return this.filter(LongPredicate.Util.negate(predicate));
    }

    public OptionalLong map(LongUnaryOperator mapper) {
        if (!this.isPresent()) {
            return OptionalLong.empty();
        }
        Objects.requireNonNull(mapper);
        return OptionalLong.of(mapper.applyAsLong(this.value));
    }

    public <U> Optional<U> mapToObj(LongFunction<U> mapper) {
        if (!this.isPresent()) {
            return Optional.empty();
        }
        Objects.requireNonNull(mapper);
        return Optional.ofNullable(mapper.apply(this.value));
    }

    public OptionalInt mapToInt(LongToIntFunction mapper) {
        if (!this.isPresent()) {
            return OptionalInt.empty();
        }
        Objects.requireNonNull(mapper);
        return OptionalInt.of(mapper.applyAsInt(this.value));
    }

    public LongStream stream() {
        if (!this.isPresent()) {
            return LongStream.empty();
        }
        return LongStream.of(this.value);
    }

    public OptionalLong or(Supplier<OptionalLong> supplier) {
        if (this.isPresent()) {
            return this;
        }
        Objects.requireNonNull(supplier);
        return Objects.requireNonNull(supplier.get());
    }

    public long orElse(long other) {
        return this.isPresent ? this.value : other;
    }

    public long orElseGet(LongSupplier other) {
        return this.isPresent ? this.value : other.getAsLong();
    }

    public long orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> long orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalLong)) {
            return false;
        }
        OptionalLong other = (OptionalLong)obj;
        return this.isPresent && other.isPresent ? this.value == other.value : this.isPresent == other.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? Objects.hashCode(this.value) : 0;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalLong[%s]", this.value) : "OptionalLong.empty";
    }
}

