/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.DoubleStream;
import com.annimon.stream.LongStream;
import com.annimon.stream.Objects;
import com.annimon.stream.OptionalInt;
import com.annimon.stream.Stream;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.IntBinaryOperator;
import com.annimon.stream.function.IntConsumer;
import com.annimon.stream.function.IntFunction;
import com.annimon.stream.function.IntPredicate;
import com.annimon.stream.function.IntSupplier;
import com.annimon.stream.function.IntToDoubleFunction;
import com.annimon.stream.function.IntToLongFunction;
import com.annimon.stream.function.IntUnaryOperator;
import com.annimon.stream.function.ObjIntConsumer;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ToIntFunction;
import com.annimon.stream.internal.Compose;
import com.annimon.stream.internal.Operators;
import com.annimon.stream.internal.Params;
import com.annimon.stream.iterator.PrimitiveIterator;
import com.annimon.stream.operator.IntArray;
import com.annimon.stream.operator.IntCodePoints;
import com.annimon.stream.operator.IntConcat;
import com.annimon.stream.operator.IntDropWhile;
import com.annimon.stream.operator.IntFilter;
import com.annimon.stream.operator.IntFlatMap;
import com.annimon.stream.operator.IntGenerate;
import com.annimon.stream.operator.IntIterate;
import com.annimon.stream.operator.IntLimit;
import com.annimon.stream.operator.IntMap;
import com.annimon.stream.operator.IntMapToDouble;
import com.annimon.stream.operator.IntMapToLong;
import com.annimon.stream.operator.IntMapToObj;
import com.annimon.stream.operator.IntPeek;
import com.annimon.stream.operator.IntRangeClosed;
import com.annimon.stream.operator.IntSample;
import com.annimon.stream.operator.IntScan;
import com.annimon.stream.operator.IntScanIdentity;
import com.annimon.stream.operator.IntSkip;
import com.annimon.stream.operator.IntSorted;
import com.annimon.stream.operator.IntTakeUntil;
import com.annimon.stream.operator.IntTakeWhile;
import java.io.Closeable;
import java.util.Comparator;
import java.util.NoSuchElementException;

public final class IntStream
implements Closeable {
    private static final IntStream EMPTY = new IntStream(new PrimitiveIterator.OfInt(){

        @Override
        public int nextInt() {
            return 0;
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    });
    private final PrimitiveIterator.OfInt iterator;
    private final Params params;
    private static final ToIntFunction<Integer> UNBOX_FUNCTION = new ToIntFunction<Integer>(){

        @Override
        public int applyAsInt(Integer t) {
            return t;
        }
    };

    public static IntStream empty() {
        return EMPTY;
    }

    public static IntStream of(PrimitiveIterator.OfInt iterator) {
        Objects.requireNonNull(iterator);
        return new IntStream(iterator);
    }

    public static IntStream of(int ... values) {
        Objects.requireNonNull(values);
        if (values.length == 0) {
            return IntStream.empty();
        }
        return new IntStream(new IntArray(values));
    }

    public static IntStream of(int t) {
        return new IntStream(new IntArray(new int[]{t}));
    }

    public static IntStream ofCodePoints(CharSequence charSequence) {
        return new IntStream(new IntCodePoints(charSequence));
    }

    public static IntStream range(int startInclusive, int endExclusive) {
        if (startInclusive >= endExclusive) {
            return IntStream.empty();
        }
        return IntStream.rangeClosed(startInclusive, endExclusive - 1);
    }

    public static IntStream rangeClosed(int startInclusive, int endInclusive) {
        if (startInclusive > endInclusive) {
            return IntStream.empty();
        }
        if (startInclusive == endInclusive) {
            return IntStream.of(startInclusive);
        }
        return new IntStream(new IntRangeClosed(startInclusive, endInclusive));
    }

    public static IntStream generate(IntSupplier s) {
        Objects.requireNonNull(s);
        return new IntStream(new IntGenerate(s));
    }

    public static IntStream iterate(int seed, IntUnaryOperator f) {
        Objects.requireNonNull(f);
        return new IntStream(new IntIterate(seed, f));
    }

    public static IntStream iterate(int seed, IntPredicate predicate, IntUnaryOperator op) {
        Objects.requireNonNull(predicate);
        return IntStream.iterate(seed, op).takeWhile(predicate);
    }

    public static IntStream concat(IntStream a, IntStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        IntStream result = new IntStream(new IntConcat(a.iterator, b.iterator));
        return result.onClose(Compose.closeables(a, b));
    }

    private IntStream(PrimitiveIterator.OfInt iterator) {
        this(null, iterator);
    }

    IntStream(Params params, PrimitiveIterator.OfInt iterator) {
        this.params = params;
        this.iterator = iterator;
    }

    public PrimitiveIterator.OfInt iterator() {
        return this.iterator;
    }

    public <R> R custom(Function<IntStream, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    public Stream<Integer> boxed() {
        return new Stream<Integer>(this.params, this.iterator);
    }

    public IntStream filter(IntPredicate predicate) {
        return new IntStream(this.params, new IntFilter(this.iterator, predicate));
    }

    public IntStream filterNot(IntPredicate predicate) {
        return this.filter(IntPredicate.Util.negate(predicate));
    }

    public IntStream map(IntUnaryOperator mapper) {
        return new IntStream(this.params, new IntMap(this.iterator, mapper));
    }

    public <R> Stream<R> mapToObj(IntFunction<? extends R> mapper) {
        return new Stream<R>(this.params, new IntMapToObj<R>(this.iterator, mapper));
    }

    public LongStream mapToLong(IntToLongFunction mapper) {
        return new LongStream(this.params, new IntMapToLong(this.iterator, mapper));
    }

    public DoubleStream mapToDouble(IntToDoubleFunction mapper) {
        return new DoubleStream(this.params, new IntMapToDouble(this.iterator, mapper));
    }

    public IntStream flatMap(IntFunction<? extends IntStream> mapper) {
        return new IntStream(this.params, new IntFlatMap(this.iterator, mapper));
    }

    public IntStream distinct() {
        return this.boxed().distinct().mapToInt(UNBOX_FUNCTION);
    }

    public IntStream sorted() {
        return new IntStream(this.params, new IntSorted(this.iterator));
    }

    public IntStream sorted(Comparator<Integer> comparator) {
        return this.boxed().sorted(comparator).mapToInt(UNBOX_FUNCTION);
    }

    public IntStream sample(int stepWidth) {
        if (stepWidth <= 0) {
            throw new IllegalArgumentException("stepWidth cannot be zero or negative");
        }
        if (stepWidth == 1) {
            return this;
        }
        return new IntStream(this.params, new IntSample(this.iterator, stepWidth));
    }

    public IntStream peek(IntConsumer action) {
        return new IntStream(this.params, new IntPeek(this.iterator, action));
    }

    public IntStream scan(IntBinaryOperator accumulator) {
        Objects.requireNonNull(accumulator);
        return new IntStream(this.params, new IntScan(this.iterator, accumulator));
    }

    public IntStream scan(int identity, IntBinaryOperator accumulator) {
        Objects.requireNonNull(accumulator);
        return new IntStream(this.params, new IntScanIdentity(this.iterator, identity, accumulator));
    }

    public IntStream takeWhile(IntPredicate predicate) {
        return new IntStream(this.params, new IntTakeWhile(this.iterator, predicate));
    }

    public IntStream takeUntil(IntPredicate stopPredicate) {
        return new IntStream(this.params, new IntTakeUntil(this.iterator, stopPredicate));
    }

    public IntStream dropWhile(IntPredicate predicate) {
        return new IntStream(this.params, new IntDropWhile(this.iterator, predicate));
    }

    public IntStream limit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("maxSize cannot be negative");
        }
        if (maxSize == 0L) {
            return IntStream.empty();
        }
        return new IntStream(this.params, new IntLimit(this.iterator, maxSize));
    }

    public IntStream skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n cannot be negative");
        }
        if (n == 0L) {
            return this;
        }
        return new IntStream(this.params, new IntSkip(this.iterator, n));
    }

    public void forEach(IntConsumer action) {
        while (this.iterator.hasNext()) {
            action.accept(this.iterator.nextInt());
        }
    }

    public int reduce(int identity, IntBinaryOperator op) {
        int result = identity;
        while (this.iterator.hasNext()) {
            int value = this.iterator.nextInt();
            result = op.applyAsInt(result, value);
        }
        return result;
    }

    public OptionalInt reduce(IntBinaryOperator op) {
        boolean foundAny = false;
        int result = 0;
        while (this.iterator.hasNext()) {
            int value = this.iterator.nextInt();
            if (!foundAny) {
                foundAny = true;
                result = value;
                continue;
            }
            result = op.applyAsInt(result, value);
        }
        return foundAny ? OptionalInt.of(result) : OptionalInt.empty();
    }

    public int[] toArray() {
        return Operators.toIntArray(this.iterator);
    }

    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator) {
        R result = supplier.get();
        while (this.iterator.hasNext()) {
            int value = this.iterator.nextInt();
            accumulator.accept(result, value);
        }
        return result;
    }

    public int sum() {
        int sum = 0;
        while (this.iterator.hasNext()) {
            sum += this.iterator.nextInt();
        }
        return sum;
    }

    public OptionalInt min() {
        return this.reduce(new IntBinaryOperator(){

            @Override
            public int applyAsInt(int left, int right) {
                return left < right ? left : right;
            }
        });
    }

    public OptionalInt max() {
        return this.reduce(new IntBinaryOperator(){

            @Override
            public int applyAsInt(int left, int right) {
                return left > right ? left : right;
            }
        });
    }

    public long count() {
        long count = 0L;
        while (this.iterator.hasNext()) {
            this.iterator.nextInt();
            ++count;
        }
        return count;
    }

    public boolean anyMatch(IntPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextInt())) continue;
            return true;
        }
        return false;
    }

    public boolean allMatch(IntPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (predicate.test(this.iterator.nextInt())) continue;
            return false;
        }
        return true;
    }

    public boolean noneMatch(IntPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextInt())) continue;
            return false;
        }
        return true;
    }

    public OptionalInt findFirst() {
        if (this.iterator.hasNext()) {
            return OptionalInt.of(this.iterator.nextInt());
        }
        return OptionalInt.empty();
    }

    public OptionalInt findLast() {
        return this.reduce(new IntBinaryOperator(){

            @Override
            public int applyAsInt(int left, int right) {
                return right;
            }
        });
    }

    public int single() {
        if (this.iterator.hasNext()) {
            int singleCandidate = this.iterator.nextInt();
            if (this.iterator.hasNext()) {
                throw new IllegalStateException("IntStream contains more than one element");
            }
            return singleCandidate;
        }
        throw new NoSuchElementException("IntStream contains no element");
    }

    public OptionalInt findSingle() {
        if (this.iterator.hasNext()) {
            int singleCandidate = this.iterator.nextInt();
            if (this.iterator.hasNext()) {
                throw new IllegalStateException("IntStream contains more than one element");
            }
            return OptionalInt.of(singleCandidate);
        }
        return OptionalInt.empty();
    }

    public IntStream onClose(Runnable closeHandler) {
        Params newParams;
        Objects.requireNonNull(closeHandler);
        if (this.params == null) {
            newParams = new Params();
            newParams.closeHandler = closeHandler;
        } else {
            newParams = this.params;
            Runnable firstHandler = newParams.closeHandler;
            newParams.closeHandler = Compose.runnables(firstHandler, closeHandler);
        }
        return new IntStream(newParams, this.iterator);
    }

    @Override
    public void close() {
        if (this.params != null && this.params.closeHandler != null) {
            this.params.closeHandler.run();
            this.params.closeHandler = null;
        }
    }
}

