/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.Objects;
import com.annimon.stream.Optional;
import com.annimon.stream.function.BooleanConsumer;
import com.annimon.stream.function.BooleanFunction;
import com.annimon.stream.function.BooleanPredicate;
import com.annimon.stream.function.BooleanSupplier;
import com.annimon.stream.function.Supplier;
import java.util.NoSuchElementException;

public final class OptionalBoolean {
    private static final OptionalBoolean EMPTY = new OptionalBoolean();
    private static final OptionalBoolean TRUE = new OptionalBoolean(true);
    private static final OptionalBoolean FALSE = new OptionalBoolean(false);
    private final boolean isPresent;
    private final boolean value;

    public static OptionalBoolean empty() {
        return EMPTY;
    }

    public static OptionalBoolean of(boolean value) {
        return value ? TRUE : FALSE;
    }

    private OptionalBoolean() {
        this.isPresent = false;
        this.value = false;
    }

    private OptionalBoolean(boolean value) {
        this.isPresent = true;
        this.value = value;
    }

    public boolean getAsBoolean() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void ifPresent(BooleanConsumer consumer) {
        if (this.isPresent) {
            consumer.accept(this.value);
        }
    }

    public void ifPresentOrElse(BooleanConsumer consumer, Runnable emptyAction) {
        if (this.isPresent) {
            consumer.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public OptionalBoolean executeIfPresent(BooleanConsumer consumer) {
        this.ifPresent(consumer);
        return this;
    }

    public OptionalBoolean executeIfAbsent(Runnable action) {
        if (!this.isPresent()) {
            action.run();
        }
        return this;
    }

    public OptionalBoolean filter(BooleanPredicate predicate) {
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : OptionalBoolean.empty();
    }

    public OptionalBoolean map(BooleanPredicate mapper) {
        if (!this.isPresent()) {
            return OptionalBoolean.empty();
        }
        Objects.requireNonNull(mapper);
        return OptionalBoolean.of(mapper.test(this.value));
    }

    public <U> Optional<U> mapToObj(BooleanFunction<U> mapper) {
        if (!this.isPresent()) {
            return Optional.empty();
        }
        Objects.requireNonNull(mapper);
        return Optional.ofNullable(mapper.apply(this.value));
    }

    public OptionalBoolean or(Supplier<OptionalBoolean> supplier) {
        if (this.isPresent()) {
            return this;
        }
        Objects.requireNonNull(supplier);
        return Objects.requireNonNull(supplier.get());
    }

    public boolean orElse(boolean other) {
        return this.isPresent ? this.value : other;
    }

    public boolean orElseGet(BooleanSupplier other) {
        return this.isPresent ? this.value : other.getAsBoolean();
    }

    public <X extends Throwable> boolean orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalBoolean)) {
            return false;
        }
        OptionalBoolean other = (OptionalBoolean)obj;
        return this.isPresent && other.isPresent ? this.value == other.value : this.isPresent == other.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? (this.value ? 1231 : 1237) : 0;
    }

    public String toString() {
        return this.isPresent ? (this.value ? "OptionalBoolean[true]" : "OptionalBoolean[false]") : "OptionalBoolean.empty";
    }
}

