/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.function.FunctionalInterface;
import com.annimon.stream.function.ThrowableLongSupplier;

@FunctionalInterface
public interface LongSupplier {
    public long getAsLong();

    public static class Util {
        private Util() {
        }

        public static LongSupplier safe(ThrowableLongSupplier<Throwable> throwableSupplier) {
            return Util.safe(throwableSupplier, 0L);
        }

        public static LongSupplier safe(final ThrowableLongSupplier<Throwable> throwableSupplier, final long resultIfFailed) {
            return new LongSupplier(){

                @Override
                public long getAsLong() {
                    try {
                        return throwableSupplier.getAsLong();
                    }
                    catch (Throwable ex) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

