/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.DoubleStream;
import com.annimon.stream.IntStream;
import com.annimon.stream.Objects;
import com.annimon.stream.OptionalLong;
import com.annimon.stream.Stream;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.LongBinaryOperator;
import com.annimon.stream.function.LongConsumer;
import com.annimon.stream.function.LongFunction;
import com.annimon.stream.function.LongPredicate;
import com.annimon.stream.function.LongSupplier;
import com.annimon.stream.function.LongToDoubleFunction;
import com.annimon.stream.function.LongToIntFunction;
import com.annimon.stream.function.LongUnaryOperator;
import com.annimon.stream.function.ObjLongConsumer;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ToLongFunction;
import com.annimon.stream.internal.Operators;
import com.annimon.stream.iterator.PrimitiveIterator;
import com.annimon.stream.operator.LongArray;
import com.annimon.stream.operator.LongConcat;
import com.annimon.stream.operator.LongDropWhile;
import com.annimon.stream.operator.LongFilter;
import com.annimon.stream.operator.LongFlatMap;
import com.annimon.stream.operator.LongGenerate;
import com.annimon.stream.operator.LongIterate;
import com.annimon.stream.operator.LongLimit;
import com.annimon.stream.operator.LongMap;
import com.annimon.stream.operator.LongMapToDouble;
import com.annimon.stream.operator.LongMapToInt;
import com.annimon.stream.operator.LongMapToObj;
import com.annimon.stream.operator.LongPeek;
import com.annimon.stream.operator.LongRangeClosed;
import com.annimon.stream.operator.LongSample;
import com.annimon.stream.operator.LongScan;
import com.annimon.stream.operator.LongScanIdentity;
import com.annimon.stream.operator.LongSkip;
import com.annimon.stream.operator.LongSorted;
import com.annimon.stream.operator.LongTakeUntil;
import com.annimon.stream.operator.LongTakeWhile;
import java.util.Comparator;
import java.util.NoSuchElementException;

public final class LongStream {
    private static final LongStream EMPTY = new LongStream(new PrimitiveIterator.OfLong(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public long nextLong() {
            return 0L;
        }
    });
    private final PrimitiveIterator.OfLong iterator;
    private static final ToLongFunction<Long> UNBOX_FUNCTION = new ToLongFunction<Long>(){

        @Override
        public long applyAsLong(Long t) {
            return t;
        }
    };

    public static LongStream empty() {
        return EMPTY;
    }

    public static LongStream of(PrimitiveIterator.OfLong iterator) {
        Objects.requireNonNull(iterator);
        return new LongStream(iterator);
    }

    public static LongStream of(long ... values) {
        Objects.requireNonNull(values);
        if (values.length == 0) {
            return LongStream.empty();
        }
        return new LongStream(new LongArray(values));
    }

    public static LongStream of(long t) {
        return new LongStream(new LongArray(new long[]{t}));
    }

    public static LongStream range(long startInclusive, long endExclusive) {
        if (startInclusive >= endExclusive) {
            return LongStream.empty();
        }
        return LongStream.rangeClosed(startInclusive, endExclusive - 1L);
    }

    public static LongStream rangeClosed(long startInclusive, long endInclusive) {
        if (startInclusive > endInclusive) {
            return LongStream.empty();
        }
        if (startInclusive == endInclusive) {
            return LongStream.of(startInclusive);
        }
        return new LongStream(new LongRangeClosed(startInclusive, endInclusive));
    }

    public static LongStream generate(LongSupplier s) {
        Objects.requireNonNull(s);
        return new LongStream(new LongGenerate(s));
    }

    public static LongStream iterate(long seed, LongUnaryOperator f) {
        Objects.requireNonNull(f);
        return new LongStream(new LongIterate(seed, f));
    }

    public static LongStream iterate(long seed, LongPredicate predicate, LongUnaryOperator op) {
        Objects.requireNonNull(predicate);
        return LongStream.iterate(seed, op).takeWhile(predicate);
    }

    public static LongStream concat(LongStream a, LongStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        return new LongStream(new LongConcat(a.iterator, b.iterator));
    }

    private LongStream(PrimitiveIterator.OfLong iterator) {
        this.iterator = iterator;
    }

    public PrimitiveIterator.OfLong iterator() {
        return this.iterator;
    }

    public <R> R custom(Function<LongStream, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    public Stream<Long> boxed() {
        return Stream.of(this.iterator);
    }

    public LongStream filter(LongPredicate predicate) {
        return new LongStream(new LongFilter(this.iterator, predicate));
    }

    public LongStream filterNot(LongPredicate predicate) {
        return this.filter(LongPredicate.Util.negate(predicate));
    }

    public LongStream map(LongUnaryOperator mapper) {
        return new LongStream(new LongMap(this.iterator, mapper));
    }

    public <R> Stream<R> mapToObj(LongFunction<? extends R> mapper) {
        return Stream.of(new LongMapToObj<R>(this.iterator, mapper));
    }

    public IntStream mapToInt(LongToIntFunction mapper) {
        return IntStream.of(new LongMapToInt(this.iterator, mapper));
    }

    public DoubleStream mapToDouble(LongToDoubleFunction mapper) {
        return DoubleStream.of(new LongMapToDouble(this.iterator, mapper));
    }

    public LongStream flatMap(LongFunction<? extends LongStream> mapper) {
        return new LongStream(new LongFlatMap(this.iterator, mapper));
    }

    public LongStream distinct() {
        return this.boxed().distinct().mapToLong(UNBOX_FUNCTION);
    }

    public LongStream sorted() {
        return new LongStream(new LongSorted(this.iterator));
    }

    public LongStream sorted(Comparator<Long> comparator) {
        return this.boxed().sorted(comparator).mapToLong(UNBOX_FUNCTION);
    }

    public LongStream sample(int stepWidth) {
        if (stepWidth <= 0) {
            throw new IllegalArgumentException("stepWidth cannot be zero or negative");
        }
        if (stepWidth == 1) {
            return this;
        }
        return new LongStream(new LongSample(this.iterator, stepWidth));
    }

    public LongStream peek(LongConsumer action) {
        return new LongStream(new LongPeek(this.iterator, action));
    }

    public LongStream scan(LongBinaryOperator accumulator) {
        Objects.requireNonNull(accumulator);
        return new LongStream(new LongScan(this.iterator, accumulator));
    }

    public LongStream scan(long identity, LongBinaryOperator accumulator) {
        Objects.requireNonNull(accumulator);
        return new LongStream(new LongScanIdentity(this.iterator, identity, accumulator));
    }

    public LongStream takeWhile(LongPredicate predicate) {
        return new LongStream(new LongTakeWhile(this.iterator, predicate));
    }

    public LongStream takeUntil(LongPredicate stopPredicate) {
        return new LongStream(new LongTakeUntil(this.iterator, stopPredicate));
    }

    public LongStream dropWhile(LongPredicate predicate) {
        return new LongStream(new LongDropWhile(this.iterator, predicate));
    }

    public LongStream limit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("maxSize cannot be negative");
        }
        if (maxSize == 0L) {
            return LongStream.empty();
        }
        return new LongStream(new LongLimit(this.iterator, maxSize));
    }

    public LongStream skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n cannot be negative");
        }
        if (n == 0L) {
            return this;
        }
        return new LongStream(new LongSkip(this.iterator, n));
    }

    public void forEach(LongConsumer action) {
        while (this.iterator.hasNext()) {
            action.accept(this.iterator.nextLong());
        }
    }

    public long reduce(long identity, LongBinaryOperator accumulator) {
        long result = identity;
        while (this.iterator.hasNext()) {
            long value = this.iterator.nextLong();
            result = accumulator.applyAsLong(result, value);
        }
        return result;
    }

    public OptionalLong reduce(LongBinaryOperator accumulator) {
        boolean foundAny = false;
        long result = 0L;
        while (this.iterator.hasNext()) {
            long value = this.iterator.nextLong();
            if (!foundAny) {
                foundAny = true;
                result = value;
                continue;
            }
            result = accumulator.applyAsLong(result, value);
        }
        return foundAny ? OptionalLong.of(result) : OptionalLong.empty();
    }

    public long[] toArray() {
        return Operators.toLongArray(this.iterator);
    }

    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator) {
        R result = supplier.get();
        while (this.iterator.hasNext()) {
            long value = this.iterator.nextLong();
            accumulator.accept(result, value);
        }
        return result;
    }

    public long sum() {
        long sum = 0L;
        while (this.iterator.hasNext()) {
            sum += this.iterator.nextLong();
        }
        return sum;
    }

    public OptionalLong min() {
        return this.reduce(new LongBinaryOperator(){

            @Override
            public long applyAsLong(long left, long right) {
                return Math.min(left, right);
            }
        });
    }

    public OptionalLong max() {
        return this.reduce(new LongBinaryOperator(){

            @Override
            public long applyAsLong(long left, long right) {
                return Math.max(left, right);
            }
        });
    }

    public long count() {
        long count = 0L;
        while (this.iterator.hasNext()) {
            this.iterator.nextLong();
            ++count;
        }
        return count;
    }

    public boolean anyMatch(LongPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextLong())) continue;
            return true;
        }
        return false;
    }

    public boolean allMatch(LongPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (predicate.test(this.iterator.nextLong())) continue;
            return false;
        }
        return true;
    }

    public boolean noneMatch(LongPredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextLong())) continue;
            return false;
        }
        return true;
    }

    public OptionalLong findFirst() {
        if (this.iterator.hasNext()) {
            return OptionalLong.of(this.iterator.nextLong());
        }
        return OptionalLong.empty();
    }

    public long single() {
        if (!this.iterator.hasNext()) {
            throw new NoSuchElementException("LongStream contains no element");
        }
        long singleCandidate = this.iterator.nextLong();
        if (this.iterator.hasNext()) {
            throw new IllegalStateException("LongStream contains more than one element");
        }
        return singleCandidate;
    }

    public OptionalLong findSingle() {
        if (!this.iterator.hasNext()) {
            return OptionalLong.empty();
        }
        long singleCandidate = this.iterator.nextLong();
        if (this.iterator.hasNext()) {
            throw new IllegalStateException("LongStream contains more than one element");
        }
        return OptionalLong.of(singleCandidate);
    }
}

