/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.IntStream;
import com.annimon.stream.LongStream;
import com.annimon.stream.Objects;
import com.annimon.stream.OptionalDouble;
import com.annimon.stream.Stream;
import com.annimon.stream.function.DoubleBinaryOperator;
import com.annimon.stream.function.DoubleConsumer;
import com.annimon.stream.function.DoubleFunction;
import com.annimon.stream.function.DoublePredicate;
import com.annimon.stream.function.DoubleSupplier;
import com.annimon.stream.function.DoubleToIntFunction;
import com.annimon.stream.function.DoubleToLongFunction;
import com.annimon.stream.function.DoubleUnaryOperator;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.ObjDoubleConsumer;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ToDoubleFunction;
import com.annimon.stream.internal.Operators;
import com.annimon.stream.iterator.PrimitiveIterator;
import com.annimon.stream.operator.DoubleArray;
import com.annimon.stream.operator.DoubleConcat;
import com.annimon.stream.operator.DoubleDropWhile;
import com.annimon.stream.operator.DoubleFilter;
import com.annimon.stream.operator.DoubleFlatMap;
import com.annimon.stream.operator.DoubleGenerate;
import com.annimon.stream.operator.DoubleIterate;
import com.annimon.stream.operator.DoubleLimit;
import com.annimon.stream.operator.DoubleMap;
import com.annimon.stream.operator.DoubleMapToInt;
import com.annimon.stream.operator.DoubleMapToLong;
import com.annimon.stream.operator.DoubleMapToObj;
import com.annimon.stream.operator.DoublePeek;
import com.annimon.stream.operator.DoubleSample;
import com.annimon.stream.operator.DoubleScan;
import com.annimon.stream.operator.DoubleScanIdentity;
import com.annimon.stream.operator.DoubleSkip;
import com.annimon.stream.operator.DoubleSorted;
import com.annimon.stream.operator.DoubleTakeUntil;
import com.annimon.stream.operator.DoubleTakeWhile;
import java.util.Comparator;
import java.util.NoSuchElementException;

public final class DoubleStream {
    private static final DoubleStream EMPTY = new DoubleStream(new PrimitiveIterator.OfDouble(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public double nextDouble() {
            return 0.0;
        }
    });
    private final PrimitiveIterator.OfDouble iterator;
    private static final ToDoubleFunction<Double> UNBOX_FUNCTION = new ToDoubleFunction<Double>(){

        @Override
        public double applyAsDouble(Double t) {
            return t;
        }
    };

    public static DoubleStream empty() {
        return EMPTY;
    }

    public static DoubleStream of(PrimitiveIterator.OfDouble iterator) {
        Objects.requireNonNull(iterator);
        return new DoubleStream(iterator);
    }

    public static DoubleStream of(double ... values) {
        Objects.requireNonNull(values);
        if (values.length == 0) {
            return DoubleStream.empty();
        }
        return new DoubleStream(new DoubleArray(values));
    }

    public static DoubleStream of(double t) {
        return new DoubleStream(new DoubleArray(new double[]{t}));
    }

    public static DoubleStream generate(DoubleSupplier s) {
        Objects.requireNonNull(s);
        return new DoubleStream(new DoubleGenerate(s));
    }

    public static DoubleStream iterate(double seed, DoubleUnaryOperator f) {
        Objects.requireNonNull(f);
        return new DoubleStream(new DoubleIterate(seed, f));
    }

    public static DoubleStream iterate(double seed, DoublePredicate predicate, DoubleUnaryOperator op) {
        Objects.requireNonNull(predicate);
        return DoubleStream.iterate(seed, op).takeWhile(predicate);
    }

    public static DoubleStream concat(DoubleStream a, DoubleStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        return new DoubleStream(new DoubleConcat(a.iterator, b.iterator));
    }

    private DoubleStream(PrimitiveIterator.OfDouble iterator) {
        this.iterator = iterator;
    }

    public PrimitiveIterator.OfDouble iterator() {
        return this.iterator;
    }

    public <R> R custom(Function<DoubleStream, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    public Stream<Double> boxed() {
        return Stream.of(this.iterator);
    }

    public DoubleStream filter(DoublePredicate predicate) {
        return new DoubleStream(new DoubleFilter(this.iterator, predicate));
    }

    public DoubleStream filterNot(DoublePredicate predicate) {
        return this.filter(DoublePredicate.Util.negate(predicate));
    }

    public DoubleStream map(DoubleUnaryOperator mapper) {
        return new DoubleStream(new DoubleMap(this.iterator, mapper));
    }

    public <R> Stream<R> mapToObj(DoubleFunction<? extends R> mapper) {
        return Stream.of(new DoubleMapToObj<R>(this.iterator, mapper));
    }

    public IntStream mapToInt(DoubleToIntFunction mapper) {
        return IntStream.of(new DoubleMapToInt(this.iterator, mapper));
    }

    public LongStream mapToLong(DoubleToLongFunction mapper) {
        return LongStream.of(new DoubleMapToLong(this.iterator, mapper));
    }

    public DoubleStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        return new DoubleStream(new DoubleFlatMap(this.iterator, mapper));
    }

    public DoubleStream distinct() {
        return this.boxed().distinct().mapToDouble(UNBOX_FUNCTION);
    }

    public DoubleStream sorted() {
        return new DoubleStream(new DoubleSorted(this.iterator));
    }

    public DoubleStream sorted(Comparator<Double> comparator) {
        return this.boxed().sorted(comparator).mapToDouble(UNBOX_FUNCTION);
    }

    public DoubleStream sample(int stepWidth) {
        if (stepWidth <= 0) {
            throw new IllegalArgumentException("stepWidth cannot be zero or negative");
        }
        if (stepWidth == 1) {
            return this;
        }
        return new DoubleStream(new DoubleSample(this.iterator, stepWidth));
    }

    public DoubleStream peek(DoubleConsumer action) {
        return new DoubleStream(new DoublePeek(this.iterator, action));
    }

    public DoubleStream scan(DoubleBinaryOperator accumulator) {
        Objects.requireNonNull(accumulator);
        return new DoubleStream(new DoubleScan(this.iterator, accumulator));
    }

    public DoubleStream scan(double identity, DoubleBinaryOperator accumulator) {
        Objects.requireNonNull(accumulator);
        return new DoubleStream(new DoubleScanIdentity(this.iterator, identity, accumulator));
    }

    public DoubleStream takeWhile(DoublePredicate predicate) {
        return new DoubleStream(new DoubleTakeWhile(this.iterator, predicate));
    }

    public DoubleStream takeUntil(DoublePredicate stopPredicate) {
        return new DoubleStream(new DoubleTakeUntil(this.iterator, stopPredicate));
    }

    public DoubleStream dropWhile(DoublePredicate predicate) {
        return new DoubleStream(new DoubleDropWhile(this.iterator, predicate));
    }

    public DoubleStream limit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("maxSize cannot be negative");
        }
        if (maxSize == 0L) {
            return DoubleStream.empty();
        }
        return new DoubleStream(new DoubleLimit(this.iterator, maxSize));
    }

    public DoubleStream skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n cannot be negative");
        }
        if (n == 0L) {
            return this;
        }
        return new DoubleStream(new DoubleSkip(this.iterator, n));
    }

    public void forEach(DoubleConsumer action) {
        while (this.iterator.hasNext()) {
            action.accept(this.iterator.nextDouble());
        }
    }

    public double reduce(double identity, DoubleBinaryOperator accumulator) {
        double result = identity;
        while (this.iterator.hasNext()) {
            double value = this.iterator.nextDouble();
            result = accumulator.applyAsDouble(result, value);
        }
        return result;
    }

    public OptionalDouble reduce(DoubleBinaryOperator accumulator) {
        boolean foundAny = false;
        double result = 0.0;
        while (this.iterator.hasNext()) {
            double value = this.iterator.nextDouble();
            if (!foundAny) {
                foundAny = true;
                result = value;
                continue;
            }
            result = accumulator.applyAsDouble(result, value);
        }
        return foundAny ? OptionalDouble.of(result) : OptionalDouble.empty();
    }

    public double[] toArray() {
        return Operators.toDoubleArray(this.iterator);
    }

    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator) {
        R result = supplier.get();
        while (this.iterator.hasNext()) {
            double value = this.iterator.nextDouble();
            accumulator.accept(result, value);
        }
        return result;
    }

    public double sum() {
        double sum = 0.0;
        while (this.iterator.hasNext()) {
            sum += this.iterator.nextDouble();
        }
        return sum;
    }

    public OptionalDouble min() {
        return this.reduce(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double left, double right) {
                return Math.min(left, right);
            }
        });
    }

    public OptionalDouble max() {
        return this.reduce(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double left, double right) {
                return Math.max(left, right);
            }
        });
    }

    public long count() {
        long count = 0L;
        while (this.iterator.hasNext()) {
            this.iterator.nextDouble();
            ++count;
        }
        return count;
    }

    public OptionalDouble average() {
        long count = 0L;
        double sum = 0.0;
        while (this.iterator.hasNext()) {
            sum += this.iterator.nextDouble();
            ++count;
        }
        if (count == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(sum / (double)count);
    }

    public boolean anyMatch(DoublePredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextDouble())) continue;
            return true;
        }
        return false;
    }

    public boolean allMatch(DoublePredicate predicate) {
        while (this.iterator.hasNext()) {
            if (predicate.test(this.iterator.nextDouble())) continue;
            return false;
        }
        return true;
    }

    public boolean noneMatch(DoublePredicate predicate) {
        while (this.iterator.hasNext()) {
            if (!predicate.test(this.iterator.nextDouble())) continue;
            return false;
        }
        return true;
    }

    public OptionalDouble findFirst() {
        if (this.iterator.hasNext()) {
            return OptionalDouble.of(this.iterator.nextDouble());
        }
        return OptionalDouble.empty();
    }

    public double single() {
        if (!this.iterator.hasNext()) {
            throw new NoSuchElementException("DoubleStream contains no element");
        }
        double singleCandidate = this.iterator.nextDouble();
        if (this.iterator.hasNext()) {
            throw new IllegalStateException("DoubleStream contains more than one element");
        }
        return singleCandidate;
    }

    public OptionalDouble findSingle() {
        if (!this.iterator.hasNext()) {
            return OptionalDouble.empty();
        }
        double singleCandidate = this.iterator.nextDouble();
        if (this.iterator.hasNext()) {
            throw new IllegalStateException("DoubleStream contains more than one element");
        }
        return OptionalDouble.of(singleCandidate);
    }
}

