/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function.ints;

import com.annimon.stream.function.FunctionalInterface;

@FunctionalInterface
public interface IntPredicate {
    public boolean test(int var1);

    public static class Util {
        private Util() {
            throw new UnsupportedOperationException();
        }

        public static IntPredicate and(final IntPredicate p1, final IntPredicate p2) {
            return new IntPredicate(){

                @Override
                public boolean test(int value) {
                    return p1.test(value) && p2.test(value);
                }
            };
        }

        public static IntPredicate or(final IntPredicate p1, final IntPredicate p2) {
            return new IntPredicate(){

                @Override
                public boolean test(int value) {
                    return p1.test(value) || p2.test(value);
                }
            };
        }

        public static IntPredicate xor(final IntPredicate p1, final IntPredicate p2) {
            return new IntPredicate(){

                @Override
                public boolean test(int value) {
                    return p1.test(value) ^ p2.test(value);
                }
            };
        }

        public static IntPredicate negate(final IntPredicate p1) {
            return new IntPredicate(){

                @Override
                public boolean test(int value) {
                    return !p1.test(value);
                }
            };
        }
    }
}

