/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.AbstractSpinedBuffer;
import com.annimon.stream.PrimitiveIterator;
import com.annimon.stream.function.IntConsumer;
import java.util.Arrays;
import java.util.Iterator;

final class SpinedBuffer {
    private SpinedBuffer() {
    }

    static class OfInt
    extends OfPrimitive<Integer, int[], IntConsumer>
    implements IntConsumer {
        OfInt() {
        }

        OfInt(int initialCapacity) {
            super(initialCapacity);
        }

        protected int[][] newArrayArray(int size) {
            return new int[size][];
        }

        @Override
        public int[] newArray(int size) {
            return new int[size];
        }

        @Override
        protected int arrayLength(int[] array) {
            return array.length;
        }

        @Override
        public void accept(int i) {
            this.preAccept();
            ((int[])this.curChunk)[this.elementIndex++] = i;
        }

        public int get(long index) {
            int ch = this.chunkFor(index);
            if (this.spineIndex == 0 && ch == 0) {
                return ((int[])this.curChunk)[(int)index];
            }
            return ((int[][])this.spine)[ch][(int)(index - this.priorElementCount[ch])];
        }

        public PrimitiveIterator.OfInt iterator() {
            return new PrimitiveIterator.OfInt(){
                long index = 0L;

                @Override
                public int nextInt() {
                    ++this.index;
                    return OfInt.this.get(this.index - 1L);
                }

                @Override
                public boolean hasNext() {
                    return this.index < OfInt.this.count();
                }
            };
        }
    }

    static abstract class OfPrimitive<E, T_ARR, T_CONS>
    extends AbstractSpinedBuffer
    implements Iterable<E> {
        T_ARR curChunk;
        T_ARR[] spine;

        OfPrimitive(int initialCapacity) {
            super(initialCapacity);
            this.curChunk = this.newArray(1 << this.initialChunkPower);
        }

        OfPrimitive() {
            this.curChunk = this.newArray(1 << this.initialChunkPower);
        }

        @Override
        public abstract Iterator<E> iterator();

        protected abstract T_ARR[] newArrayArray(int var1);

        public abstract T_ARR newArray(int var1);

        protected abstract int arrayLength(T_ARR var1);

        long capacity() {
            return this.spineIndex == 0 ? (long)this.arrayLength(this.curChunk) : this.priorElementCount[this.spineIndex] + (long)this.arrayLength(this.spine[this.spineIndex]);
        }

        private void inflateSpine() {
            if (this.spine == null) {
                this.spine = this.newArrayArray(8);
                this.priorElementCount = new long[8];
                this.spine[0] = this.curChunk;
            }
        }

        final void ensureCapacity(long targetSize) {
            long capacity = this.capacity();
            if (targetSize > capacity) {
                this.inflateSpine();
                int i = this.spineIndex + 1;
                while (targetSize > capacity) {
                    if (i >= this.spine.length) {
                        int newSpineSize = this.spine.length * 2;
                        this.spine = Arrays.copyOf(this.spine, newSpineSize);
                        this.priorElementCount = Arrays.copyOf(this.priorElementCount, newSpineSize);
                    }
                    int nextChunkSize = this.chunkSize(i);
                    this.spine[i] = this.newArray(nextChunkSize);
                    this.priorElementCount[i] = this.priorElementCount[i - 1] + (long)this.arrayLength(this.spine[i - 1]);
                    capacity += (long)nextChunkSize;
                    ++i;
                }
            }
        }

        void increaseCapacity() {
            this.ensureCapacity(this.capacity() + 1L);
        }

        int chunkFor(long index) {
            if (this.spineIndex == 0) {
                if (index < (long)this.elementIndex) {
                    return 0;
                }
                throw new IndexOutOfBoundsException(Long.toString(index));
            }
            if (index >= this.count()) {
                throw new IndexOutOfBoundsException(Long.toString(index));
            }
            for (int j = 0; j <= this.spineIndex; ++j) {
                if (index >= this.priorElementCount[j] + (long)this.arrayLength(this.spine[j])) continue;
                return j;
            }
            throw new IndexOutOfBoundsException(Long.toString(index));
        }

        void copyInto(T_ARR array, int offset) {
            long finalOffset = (long)offset + this.count();
            if (finalOffset > (long)this.arrayLength(array) || finalOffset < (long)offset) {
                throw new IndexOutOfBoundsException("does not fit");
            }
            if (this.spineIndex == 0) {
                System.arraycopy(this.curChunk, 0, array, offset, this.elementIndex);
            } else {
                for (int i = 0; i < this.spineIndex; ++i) {
                    System.arraycopy(this.spine[i], 0, array, offset, this.arrayLength(this.spine[i]));
                    offset += this.arrayLength(this.spine[i]);
                }
                if (this.elementIndex > 0) {
                    System.arraycopy(this.curChunk, 0, array, offset, this.elementIndex);
                }
            }
        }

        T_ARR asPrimitiveArray() {
            long size = this.count();
            if (size >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException("Stream size exceeds max array size");
            }
            T_ARR result = this.newArray((int)size);
            this.copyInto(result, 0);
            return result;
        }

        void preAccept() {
            if (this.elementIndex == this.arrayLength(this.curChunk)) {
                this.inflateSpine();
                if (this.spineIndex + 1 >= this.spine.length || this.spine[this.spineIndex + 1] == null) {
                    this.increaseCapacity();
                }
                this.elementIndex = 0;
                ++this.spineIndex;
                this.curChunk = this.spine[this.spineIndex];
            }
        }

        @Override
        public void clear() {
            if (this.spine != null) {
                this.curChunk = this.spine[0];
                this.spine = null;
                this.priorElementCount = null;
            }
            this.elementIndex = 0;
            this.spineIndex = 0;
        }
    }
}

