/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.Objects;
import com.annimon.stream.Optional;
import com.annimon.stream.function.Consumer;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ThrowableFunction;
import com.annimon.stream.function.ThrowableSupplier;

public class Exceptional<T> {
    private final T value;
    private final Throwable throwable;

    public static <T> Exceptional<T> of(ThrowableSupplier<T, Throwable> supplier) {
        try {
            return new Exceptional<T>(supplier.get(), null);
        }
        catch (Throwable throwable) {
            return new Exceptional<Object>(null, throwable);
        }
    }

    private Exceptional(T value, Throwable throwable) {
        this.value = value;
        this.throwable = throwable;
    }

    public T get() {
        return this.value;
    }

    public T getOrElse(T other) {
        return this.throwable == null ? this.value : other;
    }

    public Optional<T> getOptional() {
        return Optional.ofNullable(this.value);
    }

    public Throwable getException() {
        return this.throwable;
    }

    public T getOrThrow() throws Throwable {
        if (this.throwable != null) {
            throw this.throwable;
        }
        return this.value;
    }

    public T getOrThrowRuntimeException() throws RuntimeException {
        if (this.throwable != null) {
            throw new RuntimeException(this.throwable);
        }
        return this.value;
    }

    public <E extends Throwable> T getOrThrow(E exception) throws E {
        if (this.throwable != null) {
            exception.initCause(this.throwable);
            throw exception;
        }
        return this.value;
    }

    public Exceptional<T> or(Supplier<Exceptional<T>> supplier) {
        if (this.throwable == null) {
            return this;
        }
        Objects.requireNonNull(supplier);
        return Objects.requireNonNull(supplier.get());
    }

    public <U> Exceptional<U> map(ThrowableFunction<? super T, ? extends U, Throwable> mapper) {
        if (this.throwable != null) {
            return new Exceptional<Object>(null, this.throwable);
        }
        Objects.requireNonNull(mapper);
        try {
            return new Exceptional<U>(mapper.apply(this.value), null);
        }
        catch (Throwable t) {
            return new Exceptional<Object>(null, t);
        }
    }

    public Exceptional<T> ifException(Consumer<Throwable> consumer) {
        if (this.throwable != null) {
            consumer.accept(this.throwable);
        }
        return this;
    }

    public <E extends Throwable> Exceptional<T> ifExceptionIs(Class<E> throwableClass, Consumer<? super E> consumer) {
        if (this.throwable != null && throwableClass.isAssignableFrom(this.throwable.getClass())) {
            consumer.accept(this.throwable);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Exceptional)) {
            return false;
        }
        Exceptional other = (Exceptional)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.throwable, other.throwable);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.throwable);
    }

    public String toString() {
        return this.throwable == null ? String.format("Exceptional value %s", this.value) : String.format("Exceptional throwable %s", this.throwable);
    }
}

