/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.Collector;
import com.annimon.stream.Collectors;
import com.annimon.stream.LsaIterator;
import com.annimon.stream.Optional;
import com.annimon.stream.function.BiConsumer;
import com.annimon.stream.function.BiFunction;
import com.annimon.stream.function.BinaryOperator;
import com.annimon.stream.function.Consumer;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.Predicate;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.UnaryOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Stream<T> {
    private final Iterator<? extends T> iterator;
    private static final int MATCH_ANY = 0;
    private static final int MATCH_ALL = 1;
    private static final int MATCH_NONE = 2;

    public static <T> Stream<T> of(final List<? extends T> list) {
        return new Stream<T>(new LsaIterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < list.size();
            }

            @Override
            public T next() {
                return list.get(this.index++);
            }
        });
    }

    public static <K, V> Stream<Map.Entry<K, V>> of(Map<K, V> map) {
        return new Stream<Map.Entry<K, V>>(map.entrySet());
    }

    public static <T> Stream<T> of(Iterator<? extends T> iterator) {
        return new Stream<T>(iterator);
    }

    public static <T> Stream<T> of(Iterable<? extends T> iterable) {
        return new Stream<T>(iterable);
    }

    public static <T> Stream<T> of(final T ... elements) {
        return new Stream<T>(new LsaIterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < elements.length;
            }

            @Override
            public T next() {
                return elements[this.index++];
            }
        });
    }

    public static Stream<Integer> ofRange(final int from, final int to) {
        return new Stream<Integer>(new LsaIterator<Integer>(){
            private int index;
            {
                this.index = from;
            }

            @Override
            public boolean hasNext() {
                return this.index < to;
            }

            @Override
            public Integer next() {
                return this.index++;
            }
        });
    }

    public static Stream<Long> ofRange(final long from, final long to) {
        return new Stream<Long>(new LsaIterator<Long>(){
            private long index;
            {
                this.index = from;
            }

            @Override
            public boolean hasNext() {
                return this.index < to;
            }

            @Override
            public Long next() {
                return this.index++;
            }
        });
    }

    public static Stream<Integer> ofRangeClosed(final int from, final int to) {
        return new Stream<Integer>(new LsaIterator<Integer>(){
            private int index;
            private boolean hasNext;
            {
                this.index = from;
                this.hasNext = this.index <= to;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Integer next() {
                if (this.index >= to) {
                    this.hasNext = false;
                    return to;
                }
                return this.index++;
            }
        });
    }

    public static Stream<Long> ofRangeClosed(final long from, final long to) {
        return new Stream<Long>(new LsaIterator<Long>(){
            private long index;
            private boolean hasNext;
            {
                this.index = from;
                this.hasNext = this.index <= to;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Long next() {
                if (this.index >= to) {
                    this.hasNext = false;
                    return to;
                }
                return this.index++;
            }
        });
    }

    public static <T> Stream<T> generate(final Supplier<T> supplier) {
        return new Stream<T>(new LsaIterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                return supplier.get();
            }
        });
    }

    public static <T> Stream<T> iterate(final T seed, final UnaryOperator<T> op) {
        return new Stream<T>(new LsaIterator<T>(){
            private boolean firstRun = true;
            private T t;

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                if (this.firstRun) {
                    this.firstRun = false;
                    this.t = seed;
                } else {
                    this.t = op.apply(this.t);
                }
                return this.t;
            }
        });
    }

    public static <T> Stream<T> concat(Stream<? extends T> stream1, Stream<? extends T> stream2) {
        final Iterator<? extends T> it1 = stream1.iterator;
        final Iterator<? extends T> it2 = stream2.iterator;
        return new Stream<T>(new LsaIterator<T>(){

            @Override
            public boolean hasNext() {
                return it1.hasNext() || it2.hasNext();
            }

            @Override
            public T next() {
                if (it1.hasNext()) {
                    return it1.next();
                }
                return it2.next();
            }
        });
    }

    private Stream(Iterator<? extends T> iterator) {
        this.iterator = iterator;
    }

    private Stream(Iterable<? extends T> iterable) {
        this(iterable.iterator());
    }

    public Iterator<? extends T> getIterator() {
        return this.iterator;
    }

    public <R> R custom(Function<Stream<T>, R> function) {
        return function.apply(this);
    }

    public Stream<T> filter(final Predicate<? super T> predicate) {
        return new Stream<T>(new LsaIterator<T>(){
            private T next;

            @Override
            public boolean hasNext() {
                while (Stream.this.iterator.hasNext()) {
                    this.next = Stream.this.iterator.next();
                    if (!predicate.test(this.next)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                return this.next;
            }
        });
    }

    public <R> Stream<R> map(final Function<? super T, ? extends R> mapper) {
        return new Stream<T>(new LsaIterator<R>(){

            @Override
            public boolean hasNext() {
                return Stream.this.iterator.hasNext();
            }

            @Override
            public R next() {
                return mapper.apply(Stream.this.iterator.next());
            }
        });
    }

    public <R> Stream<R> flatMap(final Function<? super T, ? extends Stream<? extends R>> mapper) {
        return new Stream<T>(new LsaIterator<R>(){
            private R next;
            private Iterator<? extends R> inner;

            @Override
            public boolean hasNext() {
                if (this.inner != null && this.inner.hasNext()) {
                    this.next = this.inner.next();
                    return true;
                }
                while (Stream.this.iterator.hasNext()) {
                    Object arg;
                    Stream result;
                    if (!(this.inner != null && this.inner.hasNext() || (result = (Stream)mapper.apply(arg = Stream.this.iterator.next())) == null)) {
                        this.inner = result.iterator;
                    }
                    if (this.inner == null || !this.inner.hasNext()) continue;
                    this.next = this.inner.next();
                    return true;
                }
                return false;
            }

            @Override
            public R next() {
                return this.next;
            }
        });
    }

    public Stream<T> distinct() {
        HashSet<T> set = new HashSet<T>();
        while (this.iterator.hasNext()) {
            set.add(this.iterator.next());
        }
        return new Stream(set);
    }

    public Stream<T> sorted() {
        return this.sorted(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
        });
    }

    public Stream<T> sorted(Comparator<? super T> comparator) {
        ArrayList<T> list = new ArrayList<T>();
        while (this.iterator.hasNext()) {
            list.add(this.iterator.next());
        }
        Collections.sort(list, comparator);
        return new Stream(list);
    }

    public <R extends Comparable> Stream<T> sortBy(final Function<? super T, ? extends R> f) {
        return this.sorted(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Comparable)f.apply(o1)).compareTo(f.apply(o2));
            }
        });
    }

    public <K> Stream<Map.Entry<K, List<T>>> groupBy(Function<? super T, ? extends K> classifier) {
        return Stream.of(this.collect(Collectors.groupingBy(classifier)));
    }

    public Stream<T> peek(final Consumer<? super T> action) {
        return new Stream<T>(new LsaIterator<T>(){

            @Override
            public boolean hasNext() {
                return Stream.this.iterator.hasNext();
            }

            @Override
            public T next() {
                Object value = Stream.this.iterator.next();
                action.accept(value);
                return value;
            }
        });
    }

    public Stream<T> limit(final long maxSize) {
        return new Stream<T>(new LsaIterator<T>(){
            private long index = 0L;

            @Override
            public boolean hasNext() {
                return this.index < maxSize && Stream.this.iterator.hasNext();
            }

            @Override
            public T next() {
                ++this.index;
                return Stream.this.iterator.next();
            }
        });
    }

    public Stream<T> skip(long n) {
        for (long i = 0L; i < n && this.iterator.hasNext(); ++i) {
            this.iterator.next();
        }
        return this;
    }

    public void forEach(Consumer<? super T> action) {
        while (this.iterator.hasNext()) {
            action.accept(this.iterator.next());
        }
    }

    public T reduce(T identity, BiFunction<T, T, T> accumulator) {
        T result = identity;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            result = accumulator.apply(result, value);
        }
        return result;
    }

    public Optional<T> reduce(BiFunction<T, T, T> accumulator) {
        boolean foundAny = false;
        Object result = null;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            if (!foundAny) {
                foundAny = true;
                result = value;
                continue;
            }
            result = accumulator.apply(result, value);
        }
        return foundAny ? Optional.of(result) : Optional.empty();
    }

    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator) {
        R result = supplier.get();
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            accumulator.accept(result, value);
        }
        return result;
    }

    public <R, A> R collect(Collector<? super T, A, R> collector) {
        A container = collector.supplier().get();
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            collector.accumulator().accept(container, value);
        }
        if (collector.finisher() != null) {
            return collector.finisher().apply(container);
        }
        return (R)container;
    }

    public Optional<T> min(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.Util.minBy(comparator));
    }

    public Optional<T> max(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.Util.maxBy(comparator));
    }

    public long count() {
        long count = 0L;
        while (this.iterator.hasNext()) {
            this.iterator.next();
            ++count;
        }
        return count;
    }

    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.match(predicate, 0);
    }

    public boolean allMatch(Predicate<? super T> predicate) {
        return this.match(predicate, 1);
    }

    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.match(predicate, 2);
    }

    public Optional<T> findFirst() {
        if (this.iterator.hasNext()) {
            return Optional.of(this.iterator.next());
        }
        return Optional.empty();
    }

    private boolean match(Predicate<? super T> predicate, int matchKind) {
        boolean kindAll;
        boolean kindAny = matchKind == 0;
        boolean bl = kindAll = matchKind == 1;
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            boolean match = predicate.test(value);
            if (!(match ^ kindAll)) continue;
            return kindAny && match;
        }
        return !kindAny;
    }
}

