/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream.function;

import com.annimon.stream.Objects;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.FunctionalInterface;
import java.util.Comparator;

@FunctionalInterface
public interface BiFunction<T, U, R> {
    public R apply(T var1, U var2);

    public static class Util {
        public static <T, U, R, V> BiFunction<T, U, V> andThen(final BiFunction<? super T, ? super U, ? extends R> f1, final Function<? super R, ? extends V> f2) {
            return new BiFunction<T, U, V>(){

                @Override
                public V apply(T t, U u) {
                    return f2.apply(f1.apply(t, u));
                }
            };
        }

        public static <T> BiFunction<T, T, T> minBy(final Comparator<? super T> comparator) {
            Objects.requireNonNull(comparator);
            return new BiFunction<T, T, T>(){

                @Override
                public T apply(T a, T b) {
                    return comparator.compare(a, b) <= 0 ? a : b;
                }
            };
        }

        public static <T> BiFunction<T, T, T> maxBy(final Comparator<? super T> comparator) {
            Objects.requireNonNull(comparator);
            return new BiFunction<T, T, T>(){

                @Override
                public T apply(T a, T b) {
                    return comparator.compare(a, b) >= 0 ? a : b;
                }
            };
        }
    }
}

