/*
 * Decompiled with CFR 0.152.
 */
package com.ankushgrover.superlog.views;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.View;
import com.ankushgrover.superlog.R;
import com.ankushgrover.superlog.SuperLog;
import com.ankushgrover.superlog.SuperLogActivity;

public class SuperLogView
extends AppCompatTextView
implements View.OnClickListener {
    private Context mContext;

    public SuperLogView(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public SuperLogView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public SuperLogView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        int visibility;
        this.mContext = context;
        int backgroundColor = ContextCompat.getColor((Context)context, (int)0x1060016);
        String text = "Logs";
        int gravity = 17;
        int n = visibility = SuperLog.getBuilder().isSuperLogViewVisible() ? 0 : 8;
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SuperLogView);
            if (a.hasValue(R.styleable.SuperLogView_android_text)) {
                text = a.getString(R.styleable.SuperLogView_android_text);
            }
            if (a.hasValue(R.styleable.SuperLogView_android_background)) {
                backgroundColor = a.getInt(R.styleable.SuperLogView_android_background, backgroundColor);
            }
            if (visibility == 0 && a.hasValue(R.styleable.SuperLogView_android_visibility)) {
                int index = a.getInt(R.styleable.SuperLogView_android_visibility, visibility);
                switch (index) {
                    case 0: {
                        visibility = 0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        visibility = 8;
                    }
                }
            }
            a.recycle();
        }
        this.setText(text);
        this.setText(text);
        this.setBackgroundColor(backgroundColor);
        this.setGravity(gravity);
        this.setTypeface(this.getTypeface(), 1);
        this.setVisibility(visibility);
        this.setOnClickListener(this);
    }

    public void onClick(View view) {
        Intent intent = new Intent(this.mContext, SuperLogActivity.class);
        this.mContext.startActivity(intent);
    }
}

