/*
 * Decompiled with CFR 0.152.
 */
package com.ankushgrover.superlog.db.helpers;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.content.LocalBroadcastManager;
import com.ankushgrover.superlog.ContextWrapper;
import com.ankushgrover.superlog.constants.SuperLogConstants;
import com.ankushgrover.superlog.db.DbHelper;
import com.ankushgrover.superlog.db.listener.DataLoadListener;
import com.ankushgrover.superlog.model.SuperLogModel;
import com.ankushgrover.superlog.utils.TimeUtils;
import com.ankushgrover.superlog.utils.Utils;
import java.util.ArrayList;

public class SuperLogDbHelper
implements SuperLogConstants {
    public static final int INSERT_LOG = 100;
    public static final int GET_ALL_LOGS = 101;
    public static final int GET_ALL_LOGS_FOR_MAIL = 102;
    private static SuperLogDbHelper mInstance;

    public static synchronized SuperLogDbHelper getInstance() {
        if (mInstance == null) {
            mInstance = new SuperLogDbHelper();
        }
        return mInstance;
    }

    private static synchronized void insert(Context context, SuperLogModel log) {
        log.setTimestamp(TimeUtils.getTimeStamp());
        ContentValues values = new ContentValues();
        values.put("message", log.getMessage());
        values.put("type", Integer.valueOf(log.getType()));
        values.put("timeStamp", log.getTimestamp());
        DbHelper.getInstance(context).getWritableDatabase().insert("SuperLogTable", null, values);
        SuperLogDbHelper.sendBroadcast(context, "actionLogInserted", log);
    }

    private static synchronized ArrayList<SuperLogModel> getLogs(Context context) {
        ArrayList<SuperLogModel> logs = new ArrayList<SuperLogModel>();
        Cursor cursor = DbHelper.getInstance(context).getReadableDatabase().query("SuperLogTable", null, null, null, null, null, null);
        while (cursor.moveToNext()) {
            SuperLogModel log = new SuperLogModel();
            log.setTimestamp(cursor.getString(cursor.getColumnIndex("timeStamp")));
            log.setMessage(cursor.getString(cursor.getColumnIndex("message")));
            log.setType(cursor.getInt(cursor.getColumnIndex("type")));
            logs.add(log);
        }
        cursor.close();
        return logs;
    }

    private static synchronized String getLogsString(Context context, boolean forMail) {
        StringBuilder logs = new StringBuilder();
        Cursor cursor = DbHelper.getInstance(context).getReadableDatabase().query("SuperLogTable", null, null, null, null, null, null);
        while (cursor.moveToNext()) {
            SuperLogModel log = new SuperLogModel();
            log.setTimestamp(cursor.getString(cursor.getColumnIndex("timeStamp")));
            log.setMessage(cursor.getString(cursor.getColumnIndex("message")));
            log.setType(cursor.getInt(cursor.getColumnIndex("type")));
            logs.append(Utils.getLogStringForMail(log.getMessage(), log.getTimestamp()));
        }
        cursor.close();
        if (forMail) {
            if (!Utils.isEmpty(logs.toString())) {
                String deviceInfo = "Device: " + Build.BRAND + " " + Build.MODEL + "\nOS Version: " + Build.VERSION.RELEASE + "\n\n";
                logs.insert(0, deviceInfo);
            }
            DbHelper.getInstance(context).clear();
        }
        return logs.toString();
    }

    private static void sendBroadcast(Context context, String action, SuperLogModel log) {
        Intent intent = new Intent(action);
        intent.putExtra("log", (Parcelable)log);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
    }

    public void perform(int taskId, Bundle bundle, DataLoadListener<Object> listener, ContextWrapper wrapper) {
        new LogAsyncTask(taskId, bundle, listener, wrapper);
    }

    private static class LogAsyncTask
    extends AsyncTask<Void, Void, Object> {
        private final int taskId;
        private final Bundle bundle;
        private final DataLoadListener<Object> listener;
        private ContextWrapper wrapper;

        LogAsyncTask(int taskId, Bundle bundle, DataLoadListener<Object> listener, ContextWrapper wrapper) {
            this.taskId = taskId;
            this.bundle = bundle;
            this.listener = listener;
            this.wrapper = wrapper;
            this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }

        protected Object doInBackground(Void ... voids) {
            switch (this.taskId) {
                case 100: {
                    SuperLogModel log = (SuperLogModel)this.bundle.getParcelable("log");
                    SuperLogDbHelper.insert(this.wrapper.getContext(), log);
                    break;
                }
                case 101: {
                    return SuperLogDbHelper.getLogs(this.wrapper.getContext());
                }
                case 102: {
                    return SuperLogDbHelper.getLogsString(this.wrapper.getContext(), true);
                }
            }
            return null;
        }

        protected void onPostExecute(Object o) {
            super.onPostExecute(o);
            this.listener.onDataLoaded(o, this.taskId);
        }
    }
}

