/*
 * Decompiled with CFR 0.152.
 */
package com.ankushgrover.superlog.adapters;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.ankushgrover.superlog.R;
import com.ankushgrover.superlog.SuperLogActivity;
import com.ankushgrover.superlog.constants.SuperLogConstants;
import com.ankushgrover.superlog.model.SuperLogModel;
import com.ankushgrover.superlog.utils.Utils;
import java.util.ArrayList;

public class SuperLogAdapter
extends RecyclerView.Adapter<Holder>
implements SuperLogConstants {
    private Context context;
    private ArrayList<SuperLogModel> list;
    private ArrayList<SuperLogModel> filtered;

    public SuperLogAdapter(Context context, ArrayList<SuperLogModel> list) {
        this.context = context;
        this.list = list;
        this.filtered = new ArrayList();
        this.filtered.addAll(list);
    }

    public Holder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new Holder(LayoutInflater.from((Context)this.context).inflate(R.layout.item_super_log, parent, false));
    }

    public void onBindViewHolder(Holder holder, int position) {
        SuperLogModel log = this.filtered.get(position);
        holder.log.setText((CharSequence)Utils.getLogString(log.getMessage(), log.getTimestamp()));
        holder.log.setTextColor(ContextCompat.getColor((Context)this.context, (int)Utils.getLogType(log.getType()).getColor()));
    }

    public int getItemCount() {
        return this.filtered.size();
    }

    public void filter(String text) {
        this.filtered.clear();
        if (text == null || text.length() == 0) {
            this.filtered.addAll(this.list);
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                if (!this.list.get(i).getMessage().toLowerCase().contains(text.toLowerCase())) continue;
                this.filtered.add(this.list.get(i));
            }
        }
        ((SuperLogActivity)this.context).displayEmptyText(this.filtered.size() == 0);
        this.notifyDataSetChanged();
    }

    public int checkAndAddLog(SuperLogModel log, String query) {
        if (Utils.isEmpty(query) || log.getMessage().toLowerCase().contains(query)) {
            this.filtered.add(log);
            this.notifyDataSetChanged();
            return this.filtered.size();
        }
        return 0;
    }

    public void removeAllLogs() {
        this.filtered.clear();
        this.list.clear();
        this.notifyDataSetChanged();
    }

    class Holder
    extends RecyclerView.ViewHolder {
        private TextView log;

        public Holder(View itemView) {
            super(itemView);
            this.log = (TextView)itemView.findViewById(R.id.log);
        }
    }
}

