/*
 * Decompiled with CFR 0.152.
 */
package com.ankushgrover.superlog;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.ProgressBar;
import com.ankushgrover.superlog.ContextWrapper;
import com.ankushgrover.superlog.R;
import com.ankushgrover.superlog.SuperLog;
import com.ankushgrover.superlog.adapters.SuperLogAdapter;
import com.ankushgrover.superlog.constants.SuperLogConstants;
import com.ankushgrover.superlog.db.DbHelper;
import com.ankushgrover.superlog.db.helpers.SuperLogDbHelper;
import com.ankushgrover.superlog.db.listener.DataLoadListener;
import com.ankushgrover.superlog.model.SuperLogModel;
import com.ankushgrover.superlog.utils.Utils;
import java.util.ArrayList;

public class SuperLogActivity
extends AppCompatActivity
implements DataLoadListener<Object>,
SuperLogConstants,
View.OnClickListener,
SearchView.OnQueryTextListener,
ContextWrapper {
    private ArrayList<SuperLogModel> logs;
    private RecyclerView recycler;
    private SuperLogAdapter adapter;
    private ProgressBar progressBar;
    private BroadcastReceiver receiver;
    private boolean scroll = true;
    private SearchView searchView;
    private LinearLayoutManager layoutManager;
    private FloatingActionButton moveFab;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_super_log);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar == null) {
            Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
            this.setSupportActionBar(toolbar);
        } else {
            this.findViewById(R.id.toolbar).setVisibility(8);
        }
        this.setTitle("SuperLog");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.moveFab = (FloatingActionButton)this.findViewById(R.id.move);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress);
        this.findViewById(R.id.fab).setOnClickListener((View.OnClickListener)this);
        this.moveFab.setOnClickListener((View.OnClickListener)this);
        SuperLogDbHelper.getInstance().perform(101, null, this, this);
    }

    private void initRecycler() {
        this.recycler = (RecyclerView)this.findViewById(R.id.recycler);
        this.adapter = new SuperLogAdapter((Context)this, this.logs);
        this.layoutManager = new LinearLayoutManager((Context)this, 1, false);
        this.recycler.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.recycler.setAdapter((RecyclerView.Adapter)this.adapter);
        this.recycler.scrollToPosition(this.logs.size() - 1);
        this.recycler.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (dy < 0 && SuperLogActivity.this.moveFab.getVisibility() == 8) {
                    SuperLogActivity.this.scroll = false;
                    Utils.manageViewVisibilityReveal((View)SuperLogActivity.this.moveFab, true);
                } else if (SuperLogActivity.this.layoutManager.findLastCompletelyVisibleItemPosition() == SuperLogActivity.this.logs.size() - 1 && SuperLogActivity.this.moveFab.getVisibility() == 0) {
                    SuperLogActivity.this.scroll = true;
                    Utils.manageViewVisibilityReveal((View)SuperLogActivity.this.moveFab, false);
                }
            }
        });
        this.registerReceiver();
    }

    private void registerReceiver() {
        this.receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                switch (intent.getAction()) {
                    case "actionLogInserted": {
                        SuperLogModel log = (SuperLogModel)intent.getParcelableExtra("log");
                        SuperLogActivity.this.logs.add(log);
                        if (SuperLogActivity.this.searchView == null) break;
                        int size = SuperLogActivity.this.adapter.checkAndAddLog(log, SuperLogActivity.this.searchView.getQuery().toString());
                        if (!SuperLogActivity.this.scroll || size <= 0) break;
                        SuperLogActivity.this.recycler.smoothScrollToPosition(size - 1);
                    }
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("actionLogInserted");
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.receiver, filter);
    }

    public void onSaveInstanceState(Bundle outState, PersistableBundle outPersistentState) {
        super.onSaveInstanceState(outState, outPersistentState);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.onBackPressed();
        } else if (id2 != R.id.action_search && id2 == R.id.action_delete) {
            DbHelper.getInstance((Context)this).clear();
            this.adapter.removeAllLogs();
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onDataLoaded(Object obj, int key) {
        switch (key) {
            case 101: {
                this.progressBar.setVisibility(8);
                this.logs = new ArrayList();
                this.logs = (ArrayList)obj;
                if (this.logs.size() == 0) {
                    this.displayEmptyText(true);
                }
                this.initRecycler();
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.receiver);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.fab) {
            SuperLog.sendMail(this);
        } else if (id2 == R.id.move) {
            this.recycler.smoothScrollToPosition(this.logs.size() - 1);
            this.scroll = true;
        }
    }

    public void displayEmptyText(boolean show) {
        this.findViewById(R.id.empty).setVisibility(show ? 0 : 8);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.ag_sl_menu_search, menu2);
        MenuItem item = menu2.findItem(R.id.action_search);
        this.searchView = (SearchView)item.getActionView();
        this.searchView.setQueryHint((CharSequence)this.getString(R.string.search));
        this.searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        MenuItemCompat.setOnActionExpandListener((MenuItem)item, (MenuItemCompat.OnActionExpandListener)new MenuItemCompat.OnActionExpandListener(){

            public boolean onMenuItemActionExpand(MenuItem item) {
                return true;
            }

            public boolean onMenuItemActionCollapse(MenuItem item) {
                SuperLogActivity.this.displayEmptyText(false);
                return true;
            }
        });
        final EditText searchText = (EditText)this.searchView.findViewById(R.id.search_src_text);
        this.searchView.findViewById(R.id.search_close_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SuperLogActivity.this.displayEmptyText(false);
                searchText.setText((CharSequence)"");
                SuperLogActivity.this.searchView.setQuery((CharSequence)"", false);
            }
        });
        return true;
    }

    public boolean onQueryTextSubmit(String query) {
        return false;
    }

    public boolean onQueryTextChange(String newText) {
        if (this.adapter != null) {
            this.adapter.filter(newText);
        }
        return false;
    }

    @Override
    public Context getContext() {
        return this;
    }
}

