/*
 * Decompiled with CFR 0.152.
 */
package com.ankushgrover.superlog;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ankushgrover.superlog.ContextWrapper;
import com.ankushgrover.superlog.LogCatThread;
import com.ankushgrover.superlog.constants.SuperLogConstants;
import com.ankushgrover.superlog.db.helpers.SuperLogDbHelper;
import com.ankushgrover.superlog.db.listener.DataLoadListener;
import com.ankushgrover.superlog.model.SuperLogModel;
import com.ankushgrover.superlog.utils.Utils;

public class SuperLog
implements SuperLogConstants {
    private static final String TAG = SuperLog.class.getSimpleName();
    private static Builder BUILDER;

    static void log(int type, String msg, ContextWrapper wrapper) {
        if (BUILDER.isAddLogs() && !Utils.isEmpty(msg)) {
            Bundle bundle = new Bundle();
            bundle.putParcelable("log", (Parcelable)new SuperLogModel(msg, type));
            SuperLogDbHelper.getInstance().perform(100, bundle, new DataLoadListener<Object>(){

                @Override
                public void onDataLoaded(Object obj, int key) {
                }
            }, wrapper);
        }
    }

    static void sendMail(final ContextWrapper wrapper) {
        SuperLogDbHelper.getInstance().perform(102, null, new DataLoadListener<Object>(){

            @Override
            public void onDataLoaded(Object obj, int key) {
                String logs = (String)obj;
                if (Utils.isEmpty(logs)) {
                    Log.v((String)"SuperLog Db Empty", (String)"Tried sending mail, but the db is empty.");
                } else {
                    try {
                        Intent intent = new Intent("android.intent.action.SENDTO");
                        intent.setFlags(0x10000000);
                        intent.putExtra("android.intent.extra.SUBJECT", SuperLog.class.getSimpleName());
                        intent.setData(Uri.parse((String)"mailto:"));
                        intent.putExtra("android.intent.extra.TEXT", logs);
                        if (intent.resolveActivity(wrapper.getContext().getPackageManager()) != null) {
                            wrapper.getContext().startActivity(intent);
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)"Error Sending mail", (String)e.getMessage());
                    }
                }
            }
        }, wrapper);
    }

    public static void init(@NonNull Builder builder, ContextWrapper wrapper) {
        BUILDER = builder;
        builder.startLogCat(wrapper);
    }

    public static Builder getBuilder() {
        return BUILDER;
    }

    public static class Builder {
        private boolean superLogViewVisibility = true;
        private boolean addLogs = true;
        private LogCatThread logCatThread;

        public Builder addLogsToDb(boolean addLogs) {
            this.addLogs = addLogs;
            return this;
        }

        public boolean isSuperLogViewVisibility() {
            return this.superLogViewVisibility;
        }

        public Builder setSuperLogViewVisibility(boolean isVisible) {
            this.superLogViewVisibility = isVisible;
            return this;
        }

        private void startLogCat(ContextWrapper wrapper) {
            this.logCatThread = new LogCatThread(wrapper);
            this.logCatThread.start();
        }

        public boolean isAddLogs() {
            return this.addLogs;
        }

        public void setAddLogs(boolean addLogs) {
            this.addLogs = addLogs;
        }

        public boolean isSuperLogViewVisible() {
            return this.superLogViewVisibility;
        }
    }
}

